/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen.xplat;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.paucal.api.forge.datagen.PaucalBlockStateAndModelProvider;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class HexBlockStatesAndModels
extends PaucalBlockStateAndModelProvider {
    public HexBlockStatesAndModels(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "hexcasting", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile slateModel = this.models().getExistingFile(this.modLoc("slate"));
        this.getVariantBuilder(HexBlocks.SLATE).forAllStatesExcept(bs -> {
            int rotationX = 0;
            int rotationY = 0;
            switch ((AttachFace)bs.m_61143_(BlockSlate.ATTACH_FACE)) {
                case CEILING: {
                    rotationX = 180;
                    break;
                }
                case WALL: {
                    rotationX = 90;
                    rotationY = ((Direction)bs.m_61143_((Property)BlockSlate.FACING)).m_122424_().m_122416_() * 90;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)slateModel).rotationX(rotationX).rotationY(rotationY).uvLock(true).build();
        }, new Property[]{BlockSlate.WATERLOGGED});
        this.impetus(HexBlocks.IMPETUS_RIGHTCLICK, "impetus_rightclick", "rightclick");
        this.impetus(HexBlocks.IMPETUS_LOOK, "impetus_look", "look");
        this.impetus(HexBlocks.IMPETUS_STOREDPLAYER, "impetus_storedplayer", "storedplayer");
        this.arrowCircleBlock(HexBlocks.EMPTY_IMPETUS, "empty_impetus", this.modLoc("block/slate"), "impetus/front_empty", "impetus/back_empty", "impetus/up_empty", "impetus/down_empty", "impetus/left_empty", "impetus/right_empty");
        this.getVariantBuilder(HexBlocks.DIRECTRIX_REDSTONE).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Boolean isPowered = (Boolean)bs.m_61143_((Property)BlockRedstoneDirectrix.REDSTONE_POWERED);
            String poweredness = isPowered != false ? "powered" : "unpowered";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            ResourceLocation up = this.modLoc("block/directrix/redstone/up_" + poweredness + "_" + litness);
            ResourceLocation left = this.modLoc("block/directrix/redstone/left_" + poweredness + "_" + litness);
            ResourceLocation right = this.modLoc("block/directrix/redstone/right_" + poweredness + "_" + litness);
            ResourceLocation down = this.modLoc("block/directrix/redstone/down_" + poweredness + "_" + litness);
            ResourceLocation front = this.modLoc("block/directrix/redstone/front_" + litness);
            ResourceLocation back = this.modLoc("block/directrix/redstone/back_" + poweredness);
            ResourceLocation[] routing = HexBlockStatesAndModels.routeReslocsForArrowBlock(dir, front, back, up, down, left, right);
            String modelName = "redstone_directrix_" + poweredness + "_" + litness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, routing[0], routing[1], routing[2], routing[3], routing[4], routing[5])).texture("particle", this.modLoc("block/slate"));
            if (!isLit.booleanValue() && !isPowered.booleanValue() && dir == Direction.NORTH) {
                this.simpleBlockItem(HexBlocks.DIRECTRIX_REDSTONE, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        this.getVariantBuilder(HexBlocks.EMPTY_DIRECTRIX).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Direction.Axis axis = (Direction.Axis)bs.m_61143_((Property)BlockStateProperties.f_61365_);
            ResourceLocation horiz = this.modLoc("block/directrix/empty/horiz_" + litness);
            ResourceLocation vert = this.modLoc("block/directrix/empty/vert_" + litness);
            ResourceLocation end = this.modLoc("block/directrix/empty/end_" + litness);
            ResourceLocation x = null;
            ResourceLocation y = null;
            ResourceLocation z = null;
            switch (axis) {
                case X: {
                    x = end;
                    y = horiz;
                    z = horiz;
                    break;
                }
                case Y: {
                    x = vert;
                    y = end;
                    z = vert;
                    break;
                }
                case Z: {
                    x = horiz;
                    y = vert;
                    z = end;
                }
            }
            String modelName = "empty_directrix_" + litness + "_" + axis.m_122477_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, y, y, z, z, x, x)).texture("particle", this.modLoc("block/slate"));
            if (!isLit.booleanValue() && axis == Direction.Axis.Z) {
                this.simpleBlockItem(HexBlocks.EMPTY_DIRECTRIX, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
        ModelFile.ExistingModelFile akashicRecordModel = this.models().getExistingFile(this.modLoc("block/akashic_record"));
        this.simpleBlock(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.simpleBlockItem(HexBlocks.AKASHIC_RECORD, (ModelFile)akashicRecordModel);
        this.blockAndItem(HexBlocks.AKASHIC_CONNECTOR, (BlockModelBuilder)this.models().cubeAll("akashic_connector", this.modLoc("block/akashic/connector")));
        this.getVariantBuilder(HexBlocks.AKASHIC_BOOKSHELF).forAllStates(bs -> {
            String[] fronts;
            DatumType type = (DatumType)((Object)((Object)bs.m_61143_(BlockAkashicBookshelf.DATUM_TYPE)));
            ResourceLocation side = this.modLoc("block/akashic/bookshelf/side");
            ResourceLocation end = this.modLoc("block/akashic/bookshelf/end");
            if (type == DatumType.EMPTY) {
                fronts = new String[]{"empty"};
            } else {
                fronts = new String[4];
                for (int i = 0; i < 4; ++i) {
                    fronts[i] = type.m_7912_() + (i + 1);
                }
            }
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            for (int i = 0; i < fronts.length; ++i) {
                String front = fronts[i];
                BlockModelBuilder model = (BlockModelBuilder)this.models().orientable("akashic_bookshelf_" + type.m_7912_() + i, side, this.modLoc("block/akashic/bookshelf/" + front), end);
                Direction dir = (Direction)bs.m_61143_((Property)BlockAkashicBookshelf.FACING);
                if (dir == Direction.NORTH && type == DatumType.EMPTY) {
                    this.simpleBlockItem(HexBlocks.AKASHIC_BOOKSHELF, (ModelFile)model);
                }
                builder.modelFile((ModelFile)model).rotationY(dir.m_122424_().m_122416_() * 90).uvLock(true);
                if (i >= fronts.length - 1) continue;
                builder.nextModel();
            }
            return builder.build();
        });
        this.blockAndItem(HexBlocks.SLATE_BLOCK, (BlockModelBuilder)this.models().cubeAll("slate_block", this.modLoc("block/slate")));
        this.blockAndItem((Block)HexBlocks.AMETHYST_DUST_BLOCK, (BlockModelBuilder)this.models().singleTexture("amethyst_dust_block", this.modLoc("block/cube_half_mirrored"), "all", this.modLoc("block/amethyst_dust_block")));
        this.cubeBlockAndItem((Block)HexBlocks.AMETHYST_TILES, "amethyst_tiles");
        this.cubeBlockAndItem(HexBlocks.SCROLL_PAPER, "scroll_paper");
        this.cubeBlockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER, "ancient_scroll_paper");
        this.blockAndItem(HexBlocks.SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("scroll_paper_lantern", this.modLoc("block/scroll_paper_lantern_side"), this.modLoc("block/scroll_paper_lantern_bottom"), this.modLoc("block/scroll_paper_lantern_top")));
        this.blockAndItem(HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, (BlockModelBuilder)this.models().cubeBottomTop("ancient_scroll_paper_lantern", this.modLoc("block/ancient_scroll_paper_lantern_side"), this.modLoc("block/ancient_scroll_paper_lantern_bottom"), this.modLoc("block/ancient_scroll_paper_lantern_top")));
        this.axisBlock(HexBlocks.AKASHIC_LOG, this.modLoc("block/akashic/log"), this.modLoc("block/akashic/log_end"));
        this.axisBlock(HexBlocks.AKASHIC_LOG_STRIPPED, this.modLoc("block/akashic/log_stripped"), this.modLoc("block/akashic/log_end_stripped"));
        this.axisBlock(HexBlocks.AKASHIC_WOOD, this.modLoc("block/akashic/log"), this.modLoc("block/akashic/log"));
        this.axisBlock(HexBlocks.AKASHIC_WOOD_STRIPPED, this.modLoc("block/akashic/log_stripped"), this.modLoc("block/akashic/log_stripped"));
        this.blockAndItem(HexBlocks.AKASHIC_PANEL, (BlockModelBuilder)this.models().cubeAll("akashic_panel", this.modLoc("block/akashic/panel")));
        this.blockAndItem(HexBlocks.AKASHIC_TILE, (BlockModelBuilder)this.models().cubeAll("akashic_tile", this.modLoc("block/akashic/tile")));
        ResourceLocation leavesParent = new ResourceLocation("block/leaves");
        this.blockAndItem((Block)HexBlocks.AKASHIC_LEAVES1, (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_leaves1", leavesParent)).texture("all", this.modLoc("block/akashic/leaves1")));
        this.blockAndItem((Block)HexBlocks.AKASHIC_LEAVES2, (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_leaves2", leavesParent)).texture("all", this.modLoc("block/akashic/leaves2")));
        this.blockAndItem((Block)HexBlocks.AKASHIC_LEAVES3, (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("akashic_leaves3", leavesParent)).texture("all", this.modLoc("block/akashic/leaves3")));
        this.doorBlock(HexBlocks.AKASHIC_DOOR, this.modLoc("block/akashic/door_lower"), this.modLoc("block/akashic/door_upper"));
        this.trapdoorBlock(HexBlocks.AKASHIC_TRAPDOOR, this.modLoc("block/akashic/trapdoor"), true);
        ResourceLocation planks1 = this.modLoc("block/akashic/planks1");
        BlockModelBuilder planks_model = (BlockModelBuilder)this.models().cubeAll("akashic_planks1", planks1);
        this.simpleBlock(HexBlocks.AKASHIC_PLANKS, ConfiguredModel.builder().modelFile((ModelFile)planks_model).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("akashic_planks2", this.modLoc("block/akashic/planks2"))).weight(3).nextModel().modelFile((ModelFile)this.models().cubeAll("akashic_planks3", this.modLoc("block/akashic/planks3"))).build());
        this.simpleBlockItem(HexBlocks.AKASHIC_PLANKS, (ModelFile)planks_model);
        this.stairsBlock(HexBlocks.AKASHIC_STAIRS, planks1);
        this.slabBlock(HexBlocks.AKASHIC_SLAB, this.modLoc("block/akashic_planks1"), planks1);
        this.buttonBlock((ButtonBlock)HexBlocks.AKASHIC_BUTTON, planks1);
        this.pressurePlateBlock(HexBlocks.AKASHIC_PRESSURE_PLATE, planks1);
        ModelFile.ExistingModelFile sconceModel = this.models().getExistingFile(this.modLoc("amethyst_sconce"));
        this.simpleBlock((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        this.simpleBlockItem((Block)HexBlocks.SCONCE, (ModelFile)sconceModel);
        BlockModelBuilder conjuredModel = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("conjured")).texture("particle", this.mcLoc("block/amethyst_block"));
        this.simpleBlock(HexBlocks.CONJURED_BLOCK, (ModelFile)conjuredModel);
        this.simpleBlock(HexBlocks.CONJURED_LIGHT, (ModelFile)conjuredModel);
    }

    private void impetus(Block block, String name, String stub) {
        this.arrowCircleBlock(block, name, this.modLoc("block/slate"), "impetus/" + stub, "impetus/back", "impetus/up", "impetus/down", "impetus/left", "impetus/right");
    }

    private void arrowCircleBlock(Block block, String name, ResourceLocation particle, String frontStub, String backStub, String upStub, String downStub, String leftStub, String rightStub) {
        this.getVariantBuilder(block).forAllStates(bs -> {
            Boolean isLit = (Boolean)bs.m_61143_((Property)BlockCircleComponent.ENERGIZED);
            String litness = isLit != false ? "lit" : "dim";
            Direction dir = (Direction)bs.m_61143_((Property)BlockStateProperties.f_61372_);
            ResourceLocation up = this.modLoc("block/" + upStub + "_" + litness);
            ResourceLocation front = this.modLoc("block/" + frontStub + "_" + litness);
            ResourceLocation back = this.modLoc("block/" + backStub + "_" + litness);
            ResourceLocation left = this.modLoc("block/" + leftStub + "_" + litness);
            ResourceLocation right = this.modLoc("block/" + rightStub + "_" + litness);
            ResourceLocation down = this.modLoc("block/" + downStub + "_" + litness);
            ResourceLocation[] routing = HexBlockStatesAndModels.routeReslocsForArrowBlock(dir, front, back, up, down, left, right);
            String modelName = name + "_" + litness + "_" + dir.m_122433_();
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, routing[0], routing[1], routing[2], routing[3], routing[4], routing[5])).texture("particle", particle);
            if (!isLit.booleanValue() && dir == Direction.EAST) {
                this.simpleBlockItem(block, (ModelFile)model);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    private static ResourceLocation[] routeReslocsForArrowBlock(Direction dir, ResourceLocation front, ResourceLocation back, ResourceLocation up, ResourceLocation down, ResourceLocation left, ResourceLocation right) {
        ResourceLocation bottom = null;
        ResourceLocation top = null;
        ResourceLocation north = null;
        ResourceLocation south = null;
        ResourceLocation east = null;
        ResourceLocation west = null;
        switch (dir) {
            case UP: {
                top = front;
                bottom = back;
                south = west = up;
                east = west;
                north = west;
                break;
            }
            case DOWN: {
                bottom = front;
                top = back;
                south = west = down;
                east = west;
                north = west;
                break;
            }
            case NORTH: {
                north = front;
                south = back;
                west = left;
                east = right;
                top = up;
                bottom = down;
                break;
            }
            case SOUTH: {
                south = front;
                north = back;
                west = right;
                east = left;
                top = down;
                bottom = up;
                break;
            }
            case WEST: {
                west = front;
                east = back;
                north = right;
                south = left;
                top = left;
                bottom = left;
                break;
            }
            case EAST: {
                east = front;
                west = back;
                north = left;
                south = right;
                top = right;
                bottom = right;
            }
        }
        return new ResourceLocation[]{bottom, top, north, south, east, west};
    }
}

