/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.casting;

import at.petrak.hexcasting.api.PatternRegistry;
import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.block.circle.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.misc.DiscoveryHandlers;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.misc.HexDamageSources;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexItemTags;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.Operator;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellList;
import at.petrak.hexcasting.api.spell.Widget;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.ContinuationFrame;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.FunctionalData;
import at.petrak.hexcasting.api.spell.casting.OperatorSideEffect;
import at.petrak.hexcasting.api.spell.casting.ResolvedPatternType;
import at.petrak.hexcasting.api.spell.casting.SpellContinuation;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.spell.mishaps.Mishap;
import at.petrak.hexcasting.api.spell.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.spell.mishaps.MishapError;
import at.petrak.hexcasting.api.spell.mishaps.MishapTooManyCloseParens;
import at.petrak.hexcasting.api.spell.mishaps.MishapUnescapedValue;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.api.utils.NbtCompoundBuilder;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 T2\u00020\u0001:\u0003STUB\u001b\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006BY\b\u0002\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u001e\u0010,\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001a\u00100\u001a\u0002012\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u00102\u001a\u000203J \u00104\u001a\u0002012\u0010\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000e2\u0006\u00102\u001a\u000203J\f\u00106\u001a\b\u0012\u0004\u0012\u0002070\u000eJ\u0006\u00108\u001a\u00020\u0005J\u0006\u00109\u001a\u00020+J\u001a\u0010:\u001a\u0004\u0018\u00010.2\u0006\u0010;\u001a\u00020<2\u0006\u00102\u001a\u000203H\u0002J\u001e\u0010=\u001a\u0004\u0018\u00010.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u00102\u001a\u000203H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010;\u001a\u00020<H\u0002J\"\u0010@\u001a\u00020A2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u00102\u001a\u0002032\u0006\u0010B\u001a\u00020CJ\"\u0010D\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020F\u0018\u00010E2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001c\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\u000eJ\u0006\u0010L\u001a\u00020MJ\u001e\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020?2\u0006\u00102\u001a\u0002032\u0006\u0010B\u001a\u00020CJ\u0016\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#\u00a8\u0006V"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness;", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "prepackagedColorizer", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "(Lat/petrak/hexcasting/api/spell/casting/CastingContext;Lat/petrak/hexcasting/api/misc/FrozenColorizer;)V", "stack", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "localIota", "parenCount", "", "parenthesized", "", "escapeNext", "", "(Ljava/util/List;Lat/petrak/hexcasting/api/spell/SpellDatum;ILjava/util/List;ZLat/petrak/hexcasting/api/spell/casting/CastingContext;Lat/petrak/hexcasting/api/misc/FrozenColorizer;)V", "getCtx", "()Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "getEscapeNext", "()Z", "setEscapeNext", "(Z)V", "getLocalIota", "()Lat/petrak/hexcasting/api/spell/SpellDatum;", "setLocalIota", "(Lat/petrak/hexcasting/api/spell/SpellDatum;)V", "getParenCount", "()I", "setParenCount", "(I)V", "getParenthesized", "()Ljava/util/List;", "setParenthesized", "(Ljava/util/List;)V", "getPrepackagedColorizer", "()Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "getStack", "setStack", "applyFunctionalData", "", "data", "Lat/petrak/hexcasting/api/spell/casting/FunctionalData;", "displayPattern", "pattern", "Lat/petrak/hexcasting/api/spell/Operator;", "iota", "executeIota", "Lat/petrak/hexcasting/api/spell/casting/ControllerInfo;", "world", "Lnet/minecraft/server/level/ServerLevel;", "executeIotas", "iotas", "generateDescs", "Lnet/minecraft/network/chat/Component;", "getColorizer", "getFunctionalData", "getOperatorForFrame", "frame", "Lat/petrak/hexcasting/api/spell/casting/ContinuationFrame;", "getOperatorForPattern", "getPatternForFrame", "Lat/petrak/hexcasting/api/spell/math/HexPattern;", "getUpdate", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness$CastResult;", "continuation", "Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;", "handleParentheses", "Lkotlin/Pair;", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "performSideEffects", "info", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness$TempControllerInfo;", "sideEffects", "Lat/petrak/hexcasting/api/spell/casting/OperatorSideEffect;", "serializeToNBT", "Lnet/minecraft/nbt/CompoundTag;", "updateWithPattern", "newPat", "withdrawMana", "manaCost", "allowOvercast", "CastResult", "Companion", "TempControllerInfo", "hexcasting-forge-1.18.2"})
public final class CastingHarness {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<SpellDatum<?>> stack;
    @NotNull
    private SpellDatum<?> localIota;
    private int parenCount;
    @NotNull
    private List<? extends SpellDatum<?>> parenthesized;
    private boolean escapeNext;
    @NotNull
    private final CastingContext ctx;
    @Nullable
    private final FrozenColorizer prepackagedColorizer;
    @NotNull
    public static final String TAG_STACK = "stack";
    @NotNull
    public static final String TAG_LOCAL = "local";
    @NotNull
    public static final String TAG_PAREN_COUNT = "open_parens";
    @NotNull
    public static final String TAG_PARENTHESIZED = "parenthesized";
    @NotNull
    public static final String TAG_ESCAPE_NEXT = "escape_next";
    @NotNull
    public static final String TAG_PREPACKAGED_COLORIZER = "prepackaged_colorizer";

    private CastingHarness(List<SpellDatum<?>> stack, SpellDatum<?> localIota, int parenCount, List<? extends SpellDatum<?>> parenthesized, boolean escapeNext, CastingContext ctx, FrozenColorizer prepackagedColorizer) {
        this.stack = stack;
        this.localIota = localIota;
        this.parenCount = parenCount;
        this.parenthesized = parenthesized;
        this.escapeNext = escapeNext;
        this.ctx = ctx;
        this.prepackagedColorizer = prepackagedColorizer;
    }

    @NotNull
    public final List<SpellDatum<?>> getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull List<SpellDatum<?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.stack = list;
    }

    @NotNull
    public final SpellDatum<?> getLocalIota() {
        return this.localIota;
    }

    public final void setLocalIota(@NotNull SpellDatum<?> spellDatum) {
        Intrinsics.checkNotNullParameter(spellDatum, (String)"<set-?>");
        this.localIota = spellDatum;
    }

    public final int getParenCount() {
        return this.parenCount;
    }

    public final void setParenCount(int n) {
        this.parenCount = n;
    }

    @NotNull
    public final List<SpellDatum<?>> getParenthesized() {
        return this.parenthesized;
    }

    public final void setParenthesized(@NotNull List<? extends SpellDatum<?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.parenthesized = list;
    }

    public final boolean getEscapeNext() {
        return this.escapeNext;
    }

    public final void setEscapeNext(boolean bl) {
        this.escapeNext = bl;
    }

    @NotNull
    public final CastingContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public final FrozenColorizer getPrepackagedColorizer() {
        return this.prepackagedColorizer;
    }

    @JvmOverloads
    public CastingHarness(@NotNull CastingContext ctx, @Nullable FrozenColorizer prepackagedColorizer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this(new ArrayList(), SpellDatum.Companion.make(Widget.NULL), 0, new ArrayList(), false, ctx, prepackagedColorizer);
    }

    public /* synthetic */ CastingHarness(CastingContext castingContext, FrozenColorizer frozenColorizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            frozenColorizer = null;
        }
        this(castingContext, frozenColorizer);
    }

    @NotNull
    public final ControllerInfo executeIota(@NotNull SpellDatum<?> iota, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter(iota, (String)"iota");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.executeIotas(CollectionsKt.listOf(iota), world);
    }

    private final void displayPattern(Operator pattern, SpellDatum<?> iota) {
        if (this.ctx.getDebugPatterns()) {
            ServerPlayer serverPlayer = this.ctx.getCaster();
            Operator operator = pattern;
            if (operator == null || (operator = operator.getDisplayName()) == null) {
                operator = iota.display();
            }
            serverPlayer.m_6352_((Component)operator, Util.f_137441_);
        }
    }

    private final Operator getOperatorForPattern(SpellDatum<?> iota, ServerLevel world) {
        if (iota.getType() == DatumType.PATTERN) {
            return PatternRegistry.matchPattern((HexPattern)iota.getPayload(), world);
        }
        return null;
    }

    private final HexPattern getPatternForFrame(ContinuationFrame frame) {
        if (!(frame instanceof ContinuationFrame.Evaluate)) {
            return null;
        }
        Object obj = ((ContinuationFrame.Evaluate)frame).getList().getCar().getPayload();
        return obj instanceof HexPattern ? (HexPattern)obj : null;
    }

    private final Operator getOperatorForFrame(ContinuationFrame frame, ServerLevel world) {
        if (!(frame instanceof ContinuationFrame.Evaluate)) {
            return null;
        }
        return this.getOperatorForPattern(((ContinuationFrame.Evaluate)frame).getList().getCar(), world);
    }

    @NotNull
    public final ControllerInfo executeIotas(@NotNull List<? extends SpellDatum<?>> iotas, @NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter(iotas, (String)"iotas");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        SpellContinuation continuation = SpellContinuation.Done.INSTANCE.pushFrame(new ContinuationFrame.Evaluate(new SpellList.LList(0, iotas)));
        TempControllerInfo info = new TempControllerInfo(false, false);
        ResolvedPatternType lastResolutionType = ResolvedPatternType.UNRESOLVED;
        while (continuation instanceof SpellContinuation.NotDone && !info.getEarlyExit()) {
            CastResult castResult;
            ContinuationFrame next = ((SpellContinuation.NotDone)continuation).getFrame();
            try {
                castResult = next.evaluate(((SpellContinuation.NotDone)continuation).getNext(), world, this);
            }
            catch (Mishap mishap) {
                HexPattern pattern = this.getPatternForFrame(next);
                Operator operator = this.getOperatorForFrame(next, world);
                ResolvedPatternType resolvedPatternType = mishap.resolutionType(this.ctx);
                HexPattern hexPattern = pattern;
                if (hexPattern == null) {
                    hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
                }
                castResult = new CastResult(continuation, null, resolvedPatternType, CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, operator))));
            }
            CastResult result = castResult;
            if (result.getNewData() != null) {
                this.applyFunctionalData(result.getNewData());
            }
            continuation = result.getContinuation();
            lastResolutionType = result.getResolutionType();
            this.performSideEffects(info, result.getSideEffects());
            info.setEarlyExit(info.getEarlyExit() || !lastResolutionType.getSuccess());
        }
        if (continuation instanceof SpellContinuation.NotDone) {
            lastResolutionType = lastResolutionType.getSuccess() ? ResolvedPatternType.EVALUATED : ResolvedPatternType.ERRORED;
        }
        return new ControllerInfo(info.getPlaySound(), this.stack.isEmpty() && this.parenCount == 0 && !this.escapeNext, lastResolutionType, this.generateDescs());
    }

    @NotNull
    public final CastResult getUpdate(@NotNull SpellDatum<?> iota, @NotNull ServerLevel world, @NotNull SpellContinuation continuation) {
        Intrinsics.checkNotNullParameter(iota, (String)"iota");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        try {
            Pair<FunctionalData, ResolvedPatternType> pair = this.handleParentheses(iota);
            if (pair != null) {
                Pair<FunctionalData, ResolvedPatternType> pair2 = pair;
                boolean bl = false;
                FunctionalData data = (FunctionalData)pair2.component1();
                ResolvedPatternType resolutionType = (ResolvedPatternType)((Object)pair2.component2());
                return new CastResult(continuation, data, resolutionType, CollectionsKt.emptyList());
            }
            return iota.getType() == DatumType.PATTERN ? this.updateWithPattern((HexPattern)iota.getPayload(), world, continuation) : new CastResult(continuation, null, ResolvedPatternType.INVALID, CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(new MishapUnescapedValue(iota), new Mishap.Context(new HexPattern(HexDir.WEST, null, 2, null), null))));
        }
        catch (Mishap mishap) {
            ResolvedPatternType resolvedPatternType = mishap.resolutionType(this.ctx);
            Object obj = iota.getPayload();
            HexPattern hexPattern = obj instanceof HexPattern ? (HexPattern)obj : null;
            if (hexPattern == null) {
                hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
            }
            return new CastResult(continuation, null, resolvedPatternType, CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, this.getOperatorForPattern(iota, world)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Mishap mishap = new MishapError(exception);
            Object obj = iota.getPayload();
            HexPattern hexPattern = obj instanceof HexPattern ? (HexPattern)obj : null;
            if (hexPattern == null) {
                hexPattern = new HexPattern(HexDir.WEST, null, 2, null);
            }
            return new CastResult(continuation, null, ResolvedPatternType.ERRORED, CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(hexPattern, this.getOperatorForPattern(iota, world)))));
        }
    }

    @NotNull
    public final CastResult updateWithPattern(@NotNull HexPattern newPat, @NotNull ServerLevel world, @NotNull SpellContinuation continuation) {
        Intrinsics.checkNotNullParameter((Object)newPat, (String)"newPat");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        Pair<Operator, ResourceLocation> operatorIdPair = null;
        try {
            FunctionalData functionalData;
            operatorIdPair = PatternRegistry.matchPatternAndID(newPat, world);
            if (this.ctx.getSpellCircle() == null && !HexConfig.server().isActionAllowed((ResourceLocation)operatorIdPair.getSecond())) {
                throw new MishapDisallowedSpell(null, 1, null);
            }
            if (this.ctx.getSpellCircle() != null && !HexConfig.server().isActionAllowedInCircles((ResourceLocation)operatorIdPair.getSecond())) {
                throw new MishapDisallowedSpell("disallowed_circle");
            }
            Operator pattern = (Operator)operatorIdPair.getFirst();
            boolean unenlightened = pattern.isGreat() && !this.ctx.isCasterEnlightened();
            List sideEffects = new ArrayList();
            List<SpellDatum<?>> stack2 = null;
            SpellContinuation cont2 = continuation;
            if (!unenlightened || pattern.getAlwaysProcessGreatSpell()) {
                this.displayPattern(pattern, SpellDatum.Companion.make(newPat));
                OperationResult result = pattern.operate(continuation, CollectionsKt.toMutableList((Collection)this.stack), this.localIota, this.ctx);
                cont2 = result.getNewContinuation();
                stack2 = result.getNewStack();
                this.localIota = result.getNewLocalIota();
                sideEffects.addAll((Collection)result.getSideEffects());
            }
            if (unenlightened) {
                sideEffects.add(new OperatorSideEffect.RequiredEnlightenment(pattern.getCausesBlindDiversion()));
            }
            if (this.ctx.getSpellCircle() == null) {
                sideEffects.add(new OperatorSideEffect.Particles(new ParticleSpray(this.ctx.getPosition(), new Vec3(0.0, 1.0, 0.0), 0.5, 1.0, 0, 16, null)));
            }
            List<SpellDatum<?>> list = stack2;
            if (list != null) {
                List<SpellDatum<?>> it = list;
                boolean bl = false;
                functionalData = FunctionalData.copy$default(this.getFunctionalData(), it, 0, null, false, 14, null);
            } else {
                functionalData = null;
            }
            FunctionalData fd = functionalData;
            return new CastResult(cont2, fd, ResolvedPatternType.EVALUATED, sideEffects);
        }
        catch (Mishap mishap) {
            Pair<Operator, ResourceLocation> pair = operatorIdPair;
            return new CastResult(continuation, null, mishap.resolutionType(this.ctx), CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(mishap, new Mishap.Context(newPat, pair != null ? (Operator)pair.getFirst() : null))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Pair<Operator, ResourceLocation> pair = operatorIdPair;
            return new CastResult(continuation, null, ResolvedPatternType.ERRORED, CollectionsKt.listOf((Object)new OperatorSideEffect.DoMishap(new MishapError(exception), new Mishap.Context(newPat, pair != null ? (Operator)pair.getFirst() : null))));
        }
    }

    public final void performSideEffects(@NotNull TempControllerInfo info, @NotNull List<? extends OperatorSideEffect> sideEffects) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
        for (OperatorSideEffect operatorSideEffect : sideEffects) {
            boolean mustStop = operatorSideEffect.performEffect(this);
            if (mustStop) {
                info.setEarlyExit(true);
                break;
            }
            if (!(operatorSideEffect instanceof OperatorSideEffect.AttemptSpell) || !((OperatorSideEffect.AttemptSpell)operatorSideEffect).getHasCastingSound()) continue;
            info.setPlaySound(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> generateDescs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stack;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SpellDatum spellDatum = (SpellDatum)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.display());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final FunctionalData getFunctionalData() {
        return new FunctionalData(CollectionsKt.toList((Iterable)this.stack), this.parenCount, CollectionsKt.toList((Iterable)this.parenthesized), this.escapeNext);
    }

    public final void applyFunctionalData(@NotNull FunctionalData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.stack.clear();
        this.stack.addAll((Collection)data.getStack());
        this.parenCount = data.getParenCount();
        this.parenthesized = data.getParenthesized();
        this.escapeNext = data.getEscapeNext();
    }

    private final Pair<FunctionalData, ResolvedPatternType> handleParentheses(SpellDatum<?> iota) {
        Pair out;
        Operator operator;
        Object it;
        Object obj = iota.getPayload();
        HexPattern hexPattern = obj instanceof HexPattern ? (HexPattern)obj : null;
        if (hexPattern != null) {
            Operator operator2;
            it = hexPattern;
            boolean bl = false;
            try {
                operator2 = PatternRegistry.matchPattern((HexPattern)it, this.ctx.getWorld());
            }
            catch (Mishap mishap) {
                operator2 = null;
            }
            v1 = operator2;
        } else {
            v1 = operator = null;
        }
        if (this.parenCount > 0) {
            if (this.escapeNext) {
                newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                newParens.add(iota);
                v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, newParens, false, 3, null), (Object)((Object)ResolvedPatternType.ESCAPED));
            } else if (operator == Widget.ESCAPE) {
                v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, null, true, 7, null), (Object)((Object)ResolvedPatternType.EVALUATED));
            } else if (operator == Widget.OPEN_PAREN) {
                newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                newParens.add(iota);
                it = this.getFunctionalData();
                int n = this.parenCount + 1;
                v2 = TuplesKt.to((Object)FunctionalData.copy$default((FunctionalData)it, null, n, newParens, false, 9, null), (Object)((Object)(this.parenCount == 0 ? ResolvedPatternType.EVALUATED : ResolvedPatternType.ESCAPED)));
            } else if (operator == Widget.CLOSE_PAREN) {
                int newParenCount = this.parenCount - 1;
                if (newParenCount == 0) {
                    List newStack = CollectionsKt.toMutableList((Collection)this.stack);
                    newStack.add(SpellDatum.Companion.make(CollectionsKt.toList((Iterable)this.parenthesized)));
                    v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), newStack, newParenCount, CollectionsKt.emptyList(), false, 8, null), (Object)((Object)ResolvedPatternType.EVALUATED));
                } else {
                    if (newParenCount < 0) {
                        throw new MishapTooManyCloseParens();
                    }
                    List newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                    newParens.add(iota);
                    v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, newParenCount, newParens, false, 9, null), (Object)((Object)ResolvedPatternType.ESCAPED));
                }
            } else {
                newParens = CollectionsKt.toMutableList((Collection)this.parenthesized);
                newParens.add(iota);
                v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, newParens, false, 11, null), (Object)((Object)ResolvedPatternType.ESCAPED));
            }
        } else if (this.escapeNext) {
            List newStack = CollectionsKt.toMutableList((Collection)this.stack);
            newStack.add(iota);
            v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), newStack, 0, null, false, 6, null), (Object)((Object)ResolvedPatternType.ESCAPED));
        } else if (operator == Widget.ESCAPE) {
            v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, 0, null, true, 7, null), (Object)((Object)ResolvedPatternType.EVALUATED));
        } else if (operator == Widget.OPEN_PAREN) {
            v2 = TuplesKt.to((Object)FunctionalData.copy$default(this.getFunctionalData(), null, this.parenCount + 1, null, false, 13, null), (Object)((Object)ResolvedPatternType.EVALUATED));
        } else {
            if (operator == Widget.CLOSE_PAREN) {
                throw new MishapTooManyCloseParens();
            }
            v2 = out = (Pair)null;
        }
        if (out != null) {
            this.displayPattern(operator, iota);
        }
        return out;
    }

    public final int withdrawMana(int manaCost, boolean allowOvercast) {
        if (manaCost <= 0) {
            return 0;
        }
        int costLeft = manaCost;
        boolean fake = this.ctx.getCaster().m_7500_();
        if (this.ctx.getSpellCircle() != null) {
            if (fake) {
                return 0;
            }
            BlockEntity tile = this.ctx.getWorld().m_7702_(this.ctx.getSpellCircle().getImpetusPos());
            if (tile instanceof BlockEntityAbstractImpetus) {
                int manaAvailable = ((BlockEntityAbstractImpetus)tile).getMana();
                if (manaAvailable < 0) {
                    return 0;
                }
                int manaToTake = Math.min(costLeft, manaAvailable);
                costLeft -= manaToTake;
                ((BlockEntityAbstractImpetus)tile).setMana(manaAvailable - manaToTake);
            }
        } else {
            boolean hexHolderDrawsFromInventory;
            ItemStack casterStack = this.ctx.getCaster().m_21120_(this.ctx.getCastingHand());
            ManaHolder casterManaHolder = IXplatAbstractions.INSTANCE.findManaHolder(casterStack);
            HexHolder casterHexHolder = IXplatAbstractions.INSTANCE.findHexHolder(casterStack);
            if (casterHexHolder != null) {
                if (casterManaHolder != null) {
                    int manaAvailable = casterManaHolder.withdrawMana(-1, true);
                    int manaToTake = Math.min(costLeft, manaAvailable);
                    if (!fake) {
                        casterManaHolder.withdrawMana(manaToTake, false);
                    }
                    costLeft -= manaToTake;
                }
                v0 = casterHexHolder.canDrawManaFromInventory();
            } else {
                v0 = hexHolderDrawsFromInventory = false;
            }
            if (casterStack.m_204117_(HexItemTags.WANDS) || hexHolderDrawsFromInventory) {
                List<ManaHolder> list = DiscoveryHandlers.collectManaHolders(this);
                Intrinsics.checkNotNullExpressionValue(list, (String)"collectManaHolders(this)");
                Iterable iterable = list;
                Comparator comparator = ((Comparator)ManaHelper::compareManaItem).reversed();
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"::compareManaItem).reversed()");
                List manaSources = CollectionsKt.sortedWith((Iterable)iterable, comparator);
                for (ManaHolder source : manaSources) {
                    Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
                    if ((costLeft -= ManaHelper.extractMana$default(source, costLeft, false, fake, 4, null)) > 0) continue;
                }
                if (allowOvercast && costLeft > 0) {
                    int n;
                    double manaToHealth = HexConfig.common().manaToHealthRate();
                    double healthtoRemove = (double)costLeft / manaToHealth;
                    double manaAbleToCastFromHP = (double)this.ctx.getCaster().m_21223_() * manaToHealth;
                    int manaToActuallyPayFor = Math.min((int)manaAbleToCastFromHP, costLeft);
                    if (!fake) {
                        LivingEntity livingEntity = (LivingEntity)this.ctx.getCaster();
                        DamageSource damageSource = HexDamageSources.OVERCAST;
                        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"OVERCAST");
                        Mishap.Companion.trulyHurt(livingEntity, damageSource, (float)healthtoRemove);
                        int actuallyTaken = (int)(manaAbleToCastFromHP - (double)this.ctx.getCaster().m_21223_() * manaToHealth);
                        HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(this.ctx.getCaster(), actuallyTaken);
                        this.ctx.getCaster().m_36222_(HexStatistics.MANA_OVERCASTED, manaCost - costLeft);
                        n = actuallyTaken;
                    } else {
                        n = manaToActuallyPayFor;
                    }
                    costLeft -= n;
                }
            }
        }
        if (!fake) {
            this.ctx.getCaster().m_36222_(HexStatistics.MANA_USED, manaCost - costLeft);
            HexAdvancementTriggers.SPEND_MANA_TRIGGER.trigger(this.ctx.getCaster(), manaCost - costLeft, costLeft < 0 ? -costLeft : 0);
        }
        return fake ? 0 : costLeft;
    }

    @NotNull
    public final FrozenColorizer getColorizer() {
        if (this.prepackagedColorizer != null) {
            return this.prepackagedColorizer;
        }
        FrozenColorizer frozenColorizer = IXplatAbstractions.INSTANCE.getColorizer((Player)this.ctx.getCaster());
        Intrinsics.checkNotNullExpressionValue((Object)frozenColorizer, (String)"INSTANCE.getColorizer(this.ctx.caster)");
        return frozenColorizer;
    }

    @NotNull
    public final CompoundTag serializeToNBT() {
        String $this$remAssign$iv;
        CompoundTag compoundTag;
        NBTBuilder this_$iv = NBTBuilder.INSTANCE;
        boolean $i$f$invoke = false;
        NBTBuilder this_$iv$iv = this_$iv;
        boolean $i$f$compound = false;
        CompoundTag $this$serializeToNBT_u24lambda_u2d3 = compoundTag = NbtCompoundBuilder.constructor-impl(new CompoundTag());
        boolean bl = false;
        String string = TAG_STACK;
        Tag nbt$iv = (Tag)HexUtils.serializeToNBT((Iterable)this.stack);
        boolean bl2 = false;
        $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, nbt$iv);
        $this$remAssign$iv = TAG_LOCAL;
        nbt$iv = (Tag)this.localIota.serializeToNBT();
        bl2 = false;
        $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, nbt$iv);
        $this$remAssign$iv = TAG_PAREN_COUNT;
        int num$iv = this.parenCount;
        bl2 = false;
        int value$iv$iv = num$iv;
        boolean bl3 = false;
        IntTag intTag = IntTag.m_128679_((int)value$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)intTag, (String)"valueOf(value.toInt())");
        $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, (Tag)intTag);
        $this$remAssign$iv = TAG_ESCAPE_NEXT;
        boolean bool$iv = this.escapeNext;
        bl2 = false;
        value$iv$iv = bool$iv ? 1 : 0;
        boolean bl4 = false;
        ByteTag byteTag = ByteTag.m_128266_((byte)((byte)value$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)byteTag, (String)"valueOf(value.toByte())");
        $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, (Tag)byteTag);
        $this$remAssign$iv = TAG_PARENTHESIZED;
        nbt$iv = (Tag)HexUtils.serializeToNBT((Iterable)this.parenthesized);
        bl2 = false;
        $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, nbt$iv);
        if (this.prepackagedColorizer != null) {
            $this$remAssign$iv = TAG_PREPACKAGED_COLORIZER;
            CompoundTag compoundTag2 = this.prepackagedColorizer.serializeToNBT();
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"prepackagedColorizer.serializeToNBT()");
            nbt$iv = (Tag)compoundTag2;
            bl2 = false;
            $this$serializeToNBT_u24lambda_u2d3.m_128365_($this$remAssign$iv, nbt$iv);
        }
        return compoundTag;
    }

    @JvmOverloads
    public CastingHarness(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this(ctx, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda-6(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.items");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!ManaHelper.isManaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ManaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findManaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda-9(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35975_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.armor");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!ManaHelper.isManaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ManaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findManaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda-12(CastingHarness it) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        NonNullList nonNullList = it.ctx.getCaster().m_150109_().f_35976_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"it.ctx.caster.inventory.offhand");
        Iterable $this$filter$iv = (Iterable)nonNullList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!ManaHelper.isManaItem(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        IXplatAbstractions iXplatAbstractions = IXplatAbstractions.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)iXplatAbstractions, (String)"INSTANCE");
        IXplatAbstractions iXplatAbstractions2 = iXplatAbstractions;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ManaHolder it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ItemStack p0 = (ItemStack)element$iv$iv;
            boolean bl2 = false;
            if (iXplatAbstractions2.findManaHolder(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    @JvmStatic
    @NotNull
    public static final CastingHarness fromNBT(@NotNull CompoundTag nbt, @NotNull CastingContext ctx) {
        return Companion.fromNBT(nbt, ctx);
    }

    public /* synthetic */ CastingHarness(List stack, SpellDatum localIota, int parenCount, List parenthesized, boolean escapeNext, CastingContext ctx, FrozenColorizer prepackagedColorizer, DefaultConstructorMarker $constructor_marker) {
        this(stack, localIota, parenCount, parenthesized, escapeNext, ctx, prepackagedColorizer);
    }

    static {
        DiscoveryHandlers.addManaHolderDiscoverer(CastingHarness::_init_$lambda-6);
        DiscoveryHandlers.addManaHolderDiscoverer(CastingHarness::_init_$lambda-9);
        DiscoveryHandlers.addManaHolderDiscoverer(CastingHarness::_init_$lambda-12);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$Companion;", "", "()V", "TAG_ESCAPE_NEXT", "", "TAG_LOCAL", "TAG_PARENTHESIZED", "TAG_PAREN_COUNT", "TAG_PREPACKAGED_COLORIZER", "TAG_STACK", "fromNBT", "Lat/petrak/hexcasting/api/spell/casting/CastingHarness;", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hexcasting-forge-1.18.2"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CastingHarness fromNBT(@NotNull CompoundTag nbt, @NotNull CastingContext ctx) {
            CastingHarness castingHarness;
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            try {
                SpellDatum<?> spellDatum;
                List stack = new ArrayList();
                ListTag stackTag = NBTHelper.getListByByte(nbt, CastingHarness.TAG_STACK, (byte)10);
                for (Tag subtag : stackTag) {
                    Intrinsics.checkNotNullExpressionValue((Object)subtag, (String)"subtag");
                    SpellDatum<?> datum = SpellDatum.Companion.fromNBT(NBTHelper.getAsCompound(subtag), ctx.getWorld());
                    stack.add(datum);
                }
                CompoundTag localTag = nbt.m_128469_(CastingHarness.TAG_LOCAL);
                if (localTag.m_128440_() == 1) {
                    Intrinsics.checkNotNullExpressionValue((Object)localTag, (String)"localTag");
                    spellDatum = SpellDatum.Companion.fromNBT(localTag, ctx.getWorld());
                } else {
                    spellDatum = SpellDatum.Companion.make(Widget.NULL);
                }
                SpellDatum<?> localIota = spellDatum;
                List parenthesized = new ArrayList();
                ListTag parenTag = NBTHelper.getListByByte(nbt, CastingHarness.TAG_PARENTHESIZED, (byte)10);
                for (Tag subtag : parenTag) {
                    Intrinsics.checkNotNullExpressionValue((Object)subtag, (String)"subtag");
                    if (NBTHelper.getAsCompound(subtag).m_128440_() != 1) {
                        parenthesized.add(SpellDatum.Companion.make(HexPattern.Companion.fromNBT(NBTHelper.getAsCompound(subtag))));
                        continue;
                    }
                    parenthesized.add(SpellDatum.Companion.fromNBT(NBTHelper.getAsCompound(subtag), ctx.getWorld()));
                }
                int parenCount = nbt.m_128451_(CastingHarness.TAG_PAREN_COUNT);
                boolean escapeNext = nbt.m_128471_(CastingHarness.TAG_ESCAPE_NEXT);
                FrozenColorizer colorizer = nbt.m_128441_(CastingHarness.TAG_PREPACKAGED_COLORIZER) ? FrozenColorizer.fromNBT(nbt.m_128469_(CastingHarness.TAG_PREPACKAGED_COLORIZER)) : (FrozenColorizer)null;
                castingHarness = new CastingHarness(stack, localIota, parenCount, parenthesized, escapeNext, ctx, colorizer, null);
            }
            catch (Exception exn) {
                castingHarness = new CastingHarness(ctx, null, 2, null);
            }
            return castingHarness;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$TempControllerInfo;", "", "playSound", "", "earlyExit", "(ZZ)V", "getEarlyExit", "()Z", "setEarlyExit", "(Z)V", "getPlaySound", "setPlaySound", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    public static final class TempControllerInfo {
        private boolean playSound;
        private boolean earlyExit;

        public TempControllerInfo(boolean playSound, boolean earlyExit) {
            this.playSound = playSound;
            this.earlyExit = earlyExit;
        }

        public final boolean getPlaySound() {
            return this.playSound;
        }

        public final void setPlaySound(boolean bl) {
            this.playSound = bl;
        }

        public final boolean getEarlyExit() {
            return this.earlyExit;
        }

        public final void setEarlyExit(boolean bl) {
            this.earlyExit = bl;
        }

        public final boolean component1() {
            return this.playSound;
        }

        public final boolean component2() {
            return this.earlyExit;
        }

        @NotNull
        public final TempControllerInfo copy(boolean playSound, boolean earlyExit) {
            return new TempControllerInfo(playSound, earlyExit);
        }

        public static /* synthetic */ TempControllerInfo copy$default(TempControllerInfo tempControllerInfo, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = tempControllerInfo.playSound;
            }
            if ((n & 2) != 0) {
                bl2 = tempControllerInfo.earlyExit;
            }
            return tempControllerInfo.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "TempControllerInfo(playSound=" + this.playSound + ", earlyExit=" + this.earlyExit + ")";
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.playSound ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.earlyExit) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempControllerInfo)) {
                return false;
            }
            TempControllerInfo tempControllerInfo = (TempControllerInfo)other;
            if (this.playSound != tempControllerInfo.playSound) {
                return false;
            }
            return this.earlyExit == tempControllerInfo.earlyExit;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lat/petrak/hexcasting/api/spell/casting/CastingHarness$CastResult;", "", "continuation", "Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;", "newData", "Lat/petrak/hexcasting/api/spell/casting/FunctionalData;", "resolutionType", "Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "sideEffects", "", "Lat/petrak/hexcasting/api/spell/casting/OperatorSideEffect;", "(Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;Lat/petrak/hexcasting/api/spell/casting/FunctionalData;Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;Ljava/util/List;)V", "getContinuation", "()Lat/petrak/hexcasting/api/spell/casting/SpellContinuation;", "getNewData", "()Lat/petrak/hexcasting/api/spell/casting/FunctionalData;", "getResolutionType", "()Lat/petrak/hexcasting/api/spell/casting/ResolvedPatternType;", "getSideEffects", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "hexcasting-forge-1.18.2"})
    public static final class CastResult {
        @NotNull
        private final SpellContinuation continuation;
        @Nullable
        private final FunctionalData newData;
        @NotNull
        private final ResolvedPatternType resolutionType;
        @NotNull
        private final List<OperatorSideEffect> sideEffects;

        public CastResult(@NotNull SpellContinuation continuation, @Nullable FunctionalData newData, @NotNull ResolvedPatternType resolutionType, @NotNull List<? extends OperatorSideEffect> sideEffects) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter((Object)((Object)resolutionType), (String)"resolutionType");
            Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
            this.continuation = continuation;
            this.newData = newData;
            this.resolutionType = resolutionType;
            this.sideEffects = sideEffects;
        }

        @NotNull
        public final SpellContinuation getContinuation() {
            return this.continuation;
        }

        @Nullable
        public final FunctionalData getNewData() {
            return this.newData;
        }

        @NotNull
        public final ResolvedPatternType getResolutionType() {
            return this.resolutionType;
        }

        @NotNull
        public final List<OperatorSideEffect> getSideEffects() {
            return this.sideEffects;
        }

        @NotNull
        public final SpellContinuation component1() {
            return this.continuation;
        }

        @Nullable
        public final FunctionalData component2() {
            return this.newData;
        }

        @NotNull
        public final ResolvedPatternType component3() {
            return this.resolutionType;
        }

        @NotNull
        public final List<OperatorSideEffect> component4() {
            return this.sideEffects;
        }

        @NotNull
        public final CastResult copy(@NotNull SpellContinuation continuation, @Nullable FunctionalData newData, @NotNull ResolvedPatternType resolutionType, @NotNull List<? extends OperatorSideEffect> sideEffects) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter((Object)((Object)resolutionType), (String)"resolutionType");
            Intrinsics.checkNotNullParameter(sideEffects, (String)"sideEffects");
            return new CastResult(continuation, newData, resolutionType, sideEffects);
        }

        public static /* synthetic */ CastResult copy$default(CastResult castResult, SpellContinuation spellContinuation, FunctionalData functionalData, ResolvedPatternType resolvedPatternType, List list, int n, Object object) {
            if ((n & 1) != 0) {
                spellContinuation = castResult.continuation;
            }
            if ((n & 2) != 0) {
                functionalData = castResult.newData;
            }
            if ((n & 4) != 0) {
                resolvedPatternType = castResult.resolutionType;
            }
            if ((n & 8) != 0) {
                list = castResult.sideEffects;
            }
            return castResult.copy(spellContinuation, functionalData, resolvedPatternType, list);
        }

        @NotNull
        public String toString() {
            return "CastResult(continuation=" + this.continuation + ", newData=" + this.newData + ", resolutionType=" + this.resolutionType + ", sideEffects=" + this.sideEffects + ")";
        }

        public int hashCode() {
            int result = this.continuation.hashCode();
            result = result * 31 + (this.newData == null ? 0 : this.newData.hashCode());
            result = result * 31 + this.resolutionType.hashCode();
            result = result * 31 + ((Object)this.sideEffects).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CastResult)) {
                return false;
            }
            CastResult castResult = (CastResult)other;
            if (!Intrinsics.areEqual((Object)this.continuation, (Object)castResult.continuation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newData, (Object)castResult.newData)) {
                return false;
            }
            if (this.resolutionType != castResult.resolutionType) {
                return false;
            }
            return Intrinsics.areEqual(this.sideEffects, castResult.sideEffects);
        }
    }
}

