/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.block.circle;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ControllerInfo;
import at.petrak.hexcasting.api.spell.casting.SpellCircleContext;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.api.utils.ManaHelper;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityAbstractImpetus
extends HexBlockEntity
implements WorldlyContainer {
    public static final String TAG_ACTIVATOR = "activator";
    public static final String TAG_COLORIZER = "colorizer";
    public static final String TAG_NEXT_BLOCK = "next_block";
    public static final String TAG_TRACKED_BLOCKS = "tracked_blocks";
    public static final String TAG_FOUND_ALL = "found_all";
    public static final String TAG_MANA = "mana";
    public static final String TAG_LAST_MISHAP = "last_mishap";
    private static final DecimalFormat DUST_AMOUNT = new DecimalFormat("###,###.##");
    @Nullable
    private UUID activator = null;
    @Nullable
    private FrozenColorizer colorizer = null;
    @Nullable
    private BlockPos nextBlock = null;
    @Nullable
    private List<BlockPos> trackedBlocks = null;
    private transient Set<BlockPos> knownBlocks = null;
    private boolean foundAll = false;
    @Nullable
    private Component lastMishap = null;
    private static final int MAX_CAPACITY = 2000000000;
    private int mana = 0;
    private static final int[] MAJOR_SCALE = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
    private static final int[] MINOR_SCALE = new int[]{0, 2, 3, 5, 7, 8, 11, 12};
    private static final int[] DORIAN_SCALE = new int[]{0, 2, 3, 5, 7, 9, 10, 12};
    private static final int[] MIXOLYDIAN_SCALE = new int[]{0, 2, 4, 5, 7, 9, 10, 12};
    private static final int[] BLUES_SCALE = new int[]{0, 3, 5, 6, 7, 10, 12};
    private static final int[] BAD_TIME = new int[]{0, 0, 12, 7, 6, 5, 3, 0, 3, 5};
    private static final int[] SUSSY_BAKA = new int[]{5, 8, 10, 11, 10, 8, 5, 3, 7, 5};
    private static final int[] SLOTS = new int[]{0};

    public BlockEntityAbstractImpetus(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public abstract boolean activatorAlwaysInRange();

    public int getMana() {
        return this.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    @Nullable
    public Component getLastMishap() {
        return this.lastMishap;
    }

    public void setLastMishap(@Nullable Component lastMishap) {
        this.lastMishap = lastMishap;
    }

    public void activateSpellCircle(ServerPlayer activator) {
        if (this.nextBlock != null) {
            return;
        }
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), this.getTickSpeed());
        this.activator = activator.m_142081_();
        this.nextBlock = this.m_58899_();
        this.trackedBlocks = new ArrayList<BlockPos>();
        this.knownBlocks = new HashSet<BlockPos>();
        this.colorizer = IXplatAbstractions.INSTANCE.getColorizer((Player)activator);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockAbstractImpetus.ENERGIZED, (Comparable)Boolean.valueOf(true)));
        this.stepCircle();
    }

    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)blockEntity;
            if (beai.getMana() < 0) {
                lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)HexItems.AMETHYST_DUST), (Object)ItemCreativeUnlocker.infiniteMedia(world)));
            } else {
                TranslatableComponent dustCmp = new TranslatableComponent("hexcasting.tooltip.mana", new Object[]{DUST_AMOUNT.format((float)beai.getMana() / 10000.0f)});
                lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)HexItems.AMETHYST_DUST), (Object)dustCmp));
            }
            Component mishap = this.getLastMishap();
            if (mishap != null) {
                lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)Items.f_42710_), (Object)mishap));
            }
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        if (this.activator != null && this.colorizer != null && this.nextBlock != null && this.trackedBlocks != null) {
            tag.m_128362_(TAG_ACTIVATOR, this.activator);
            tag.m_128365_(TAG_NEXT_BLOCK, (Tag)NbtUtils.m_129224_((BlockPos)this.nextBlock));
            tag.m_128365_(TAG_COLORIZER, (Tag)this.colorizer.serializeToNBT());
            tag.m_128379_(TAG_FOUND_ALL, this.foundAll);
            ListTag trackeds = new ListTag();
            for (BlockPos tracked : this.trackedBlocks) {
                trackeds.add((Object)NbtUtils.m_129224_((BlockPos)tracked));
            }
            tag.m_128365_(TAG_TRACKED_BLOCKS, (Tag)trackeds);
        }
        tag.m_128405_(TAG_MANA, this.mana);
        if (this.lastMishap != null) {
            tag.m_128359_(TAG_LAST_MISHAP, Component.Serializer.m_130703_((Component)this.lastMishap));
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        if (tag.m_128425_(TAG_ACTIVATOR, 11) && tag.m_128425_(TAG_COLORIZER, 10) && tag.m_128425_(TAG_NEXT_BLOCK, 10) && tag.m_128425_(TAG_TRACKED_BLOCKS, 9)) {
            this.activator = tag.m_128342_(TAG_ACTIVATOR);
            this.colorizer = FrozenColorizer.fromNBT(tag.m_128469_(TAG_COLORIZER));
            this.nextBlock = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_NEXT_BLOCK));
            this.foundAll = tag.m_128471_(TAG_FOUND_ALL);
            ListTag trackeds = tag.m_128437_(TAG_TRACKED_BLOCKS, 10);
            this.trackedBlocks = new ArrayList<BlockPos>(trackeds.size());
            this.knownBlocks = new HashSet<BlockPos>();
            for (Tag tracked : trackeds) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)((CompoundTag)tracked));
                this.trackedBlocks.add(pos);
                this.knownBlocks.add(pos);
            }
        } else {
            this.activator = null;
            this.colorizer = null;
            this.nextBlock = null;
            this.foundAll = false;
            this.trackedBlocks = new ArrayList<BlockPos>();
            this.knownBlocks = new HashSet<BlockPos>();
        }
        this.mana = tag.m_128451_(TAG_MANA);
        this.lastMishap = tag.m_128425_(TAG_LAST_MISHAP, 8) ? Component.Serializer.m_130701_((String)tag.m_128461_(TAG_LAST_MISHAP)) : null;
    }

    void stepCircle() {
        this.m_6596_();
        if (this.activator == null || this.colorizer == null || this.nextBlock == null || this.trackedBlocks == null) {
            return;
        }
        BlockPos possibleErrorPos = this.checkEverythingOk();
        if (possibleErrorPos != null) {
            this.sfx(possibleErrorPos, false);
            this.stopCasting();
            return;
        }
        if (this.foundAll) {
            this.clearEnergized();
            this.castSpell();
            this.stopCasting();
            return;
        }
        BlockState bsHere = this.f_58857_.m_8055_(this.nextBlock);
        if (!this.trackedBlocks.isEmpty() && bsHere.m_60734_() instanceof BlockAbstractImpetus) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        Block blockHere = bsHere.m_60734_();
        if (!(blockHere instanceof BlockCircleComponent)) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        BlockCircleComponent cc = (BlockCircleComponent)blockHere;
        Direction thisNormal = cc.normalDir(this.nextBlock, bsHere, this.f_58857_);
        EnumSet<Direction> possibleExits = cc.exitDirections(this.nextBlock, bsHere, this.f_58857_);
        BlockPos foundPos = null;
        for (Direction exit : possibleExits) {
            BlockCircleComponent cc2;
            Block block;
            BlockPos neighborPos = this.nextBlock.m_142300_(exit);
            BlockState blockThere = this.f_58857_.m_8055_(neighborPos);
            boolean closedLoop = this.trackedBlocks.size() >= 3 && this.trackedBlocks.get(0).equals((Object)neighborPos);
            boolean mightBeOkThere = closedLoop || this.trackedBlocks.isEmpty() || !this.trackedBlocks.get(this.trackedBlocks.size() - 1).equals((Object)neighborPos);
            if (!mightBeOkThere || !((block = blockThere.m_60734_()) instanceof BlockCircleComponent) || !(cc2 = (BlockCircleComponent)block).canEnterFromDirection(exit.m_122424_(), thisNormal, neighborPos, blockThere, this.f_58857_) || ((Boolean)blockThere.m_61143_((Property)BlockCircleComponent.ENERGIZED)).booleanValue() && !this.knownBlocks.contains(neighborPos)) continue;
            if (foundPos == null) {
                foundPos = neighborPos;
                this.foundAll |= closedLoop;
                continue;
            }
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        if (foundPos == null) {
            this.sfx(this.nextBlock, false);
            this.stopCasting();
            return;
        }
        this.trackedBlocks.add(this.nextBlock);
        this.knownBlocks.add(this.nextBlock);
        this.nextBlock = foundPos;
        BlockPos lastPos = this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        BlockState justTrackedBlock = this.f_58857_.m_8055_(lastPos);
        this.f_58857_.m_46597_(lastPos, (BlockState)justTrackedBlock.m_61124_((Property)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(true)));
        this.sfx(lastPos, true);
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), this.getTickSpeed());
    }

    private void castSpell() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            AABB bounds = BlockEntityAbstractImpetus.getBounds(this.trackedBlocks);
            CastingContext ctx = new CastingContext(splayer, InteractionHand.MAIN_HAND, new SpellCircleContext(this.m_58899_(), bounds, this.activatorAlwaysInRange()));
            CastingHarness harness = new CastingHarness(ctx);
            boolean makeSound = false;
            BlockPos erroredPos = null;
            for (BlockPos tracked : this.trackedBlocks) {
                BlockCircleComponent cc;
                HexPattern newPattern;
                BlockState bs = this.f_58857_.m_8055_(tracked);
                Block block = bs.m_60734_();
                if (!(block instanceof BlockCircleComponent) || (newPattern = (cc = (BlockCircleComponent)block).getPattern(tracked, bs, this.f_58857_)) == null) continue;
                ControllerInfo info = harness.executeIota(SpellDatum.make(newPattern), splayer.m_183503_());
                if (info.getMakesCastSound()) {
                    makeSound = true;
                }
                if (info.getResolutionType().getSuccess()) continue;
                erroredPos = tracked;
                break;
            }
            if (makeSound) {
                this.f_58857_.m_5594_(null, this.m_58899_(), HexSounds.SPELL_CIRCLE_CAST, SoundSource.BLOCKS, 2.0f, 1.0f);
            }
            if (erroredPos != null) {
                this.sfx(erroredPos, false);
            } else {
                this.setLastMishap(null);
            }
            this.m_6596_();
        }
    }

    @Contract(pure=true)
    private static AABB getBounds(List<BlockPos> poses) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : poses) {
            if (pos.m_123341_() < minX) {
                minX = pos.m_123341_();
            }
            if (pos.m_123342_() < minY) {
                minY = pos.m_123342_();
            }
            if (pos.m_123343_() < minZ) {
                minZ = pos.m_123343_();
            }
            if (pos.m_123341_() > maxX) {
                maxX = pos.m_123341_();
            }
            if (pos.m_123342_() > maxY) {
                maxY = pos.m_123342_();
            }
            if (pos.m_123343_() <= maxZ) continue;
            maxZ = pos.m_123343_();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    @Nullable
    private BlockPos checkEverythingOk() {
        if (this.getPlayer() == null) {
            return this.m_58899_();
        }
        for (BlockPos pos : this.trackedBlocks) {
            if (this.f_58857_.m_8055_(pos).m_60734_() instanceof BlockCircleComponent) continue;
            return pos;
        }
        if (this.trackedBlocks.size() > HexConfig.server().maxSpellCircleLength()) {
            return this.trackedBlocks.get(this.trackedBlocks.size() - 1);
        }
        return null;
    }

    private void sfx(BlockPos pos, boolean success) {
        Vec3 vpos;
        Vec3 vecOutDir;
        Direction outDir;
        BlockState bs = this.f_58857_.m_8055_(pos);
        Block block = bs.m_60734_();
        if (block instanceof BlockCircleComponent) {
            BlockCircleComponent bcc = (BlockCircleComponent)block;
            outDir = bcc.normalDir(pos, bs, this.f_58857_);
            float height = bcc.particleHeight(pos, bs, this.f_58857_);
            vecOutDir = new Vec3(outDir.m_122432_());
            vpos = Vec3.m_82512_((Vec3i)pos).m_82549_(vecOutDir.m_82490_((double)height));
        } else {
            vpos = Vec3.m_82512_((Vec3i)pos);
            vecOutDir = new Vec3(0.0, 0.0, 0.0);
        }
        outDir = this.f_58857_;
        if (outDir instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)outDir;
            ParticleSpray spray = new ParticleSpray(vpos, vecOutDir.m_82490_(success ? 1.0 : 1.5), success ? 0.1 : 0.5, (float)Math.PI / (float)(success ? 4 : 2), success ? 30 : 100);
            spray.sprayParticles(serverLevel, success ? this.colorizer : new FrozenColorizer(new ItemStack((ItemLike)HexItems.DYE_COLORIZERS.get(DyeColor.RED)), this.activator));
        }
        float pitch = 1.0f;
        SoundEvent sound = HexSounds.SPELL_CIRCLE_FAIL;
        if (success) {
            sound = HexSounds.SPELL_CIRCLE_FIND_BLOCK;
            int note = this.trackedBlocks.size() - 1;
            int semitone = this.semitoneFromScale(note);
            pitch = (float)Math.pow(2.0, (double)(semitone - 8) / 12.0);
        }
        this.f_58857_.m_6263_(null, vpos.f_82479_, vpos.f_82480_, vpos.f_82481_, sound, SoundSource.BLOCKS, 1.0f, pitch);
    }

    protected void clearEnergized() {
        if (this.trackedBlocks != null) {
            for (BlockPos tracked : this.trackedBlocks) {
                BlockState bs = this.f_58857_.m_8055_(tracked);
                if (!(bs.m_60734_() instanceof BlockCircleComponent)) continue;
                this.f_58857_.m_46597_(tracked, (BlockState)bs.m_61124_((Property)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected void stopCasting() {
        this.clearEnergized();
        this.activator = null;
        this.nextBlock = null;
        this.trackedBlocks = null;
        this.foundAll = false;
        if (this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof BlockAbstractImpetus) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    protected Player getPlayer() {
        return this.f_58857_.m_46003_(this.activator);
    }

    protected int getTickSpeed() {
        if (this.trackedBlocks == null) {
            return 10;
        }
        return Math.max(2, 10 - this.trackedBlocks.size() / 3);
    }

    protected int semitoneFromScale(int note) {
        BlockState blockBelow = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
        int[] scale = MAJOR_SCALE;
        if (blockBelow.m_60713_(Blocks.f_50723_)) {
            scale = MINOR_SCALE;
        } else if (blockBelow.m_204336_(BlockTags.f_13103_) || blockBelow.m_204336_(BlockTags.f_13036_)) {
            scale = DORIAN_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50039_) || blockBelow.m_60713_(Blocks.f_50032_)) {
            scale = MIXOLYDIAN_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50105_) || blockBelow.m_60713_(Blocks.f_50501_) || blockBelow.m_60713_(Blocks.f_50517_) || blockBelow.m_60713_(Blocks.f_50298_) || blockBelow.m_60713_(Blocks.f_50537_) || blockBelow.m_60713_(Blocks.f_50211_) || blockBelow.m_60713_(Blocks.f_50367_)) {
            scale = BLUES_SCALE;
        } else if (blockBelow.m_60713_(Blocks.f_50453_)) {
            scale = BAD_TIME;
        } else if (blockBelow.m_60713_(Blocks.f_50715_)) {
            scale = SUSSY_BAKA;
        }
        note = Mth.m_14045_((int)note, (int)0, (int)(scale.length - 1));
        return scale[note];
    }

    public int[] m_7071_(Direction var1) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction dir) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int var1, ItemStack var2, Direction var3) {
        return false;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return true;
    }

    public ItemStack m_8020_(int index) {
        return ItemStack.f_41583_.m_41777_();
    }

    public ItemStack m_7407_(int index, int count) {
        return ItemStack.f_41583_.m_41777_();
    }

    public ItemStack m_8016_(int index) {
        return ItemStack.f_41583_.m_41777_();
    }

    public void m_6836_(int index, ItemStack stack) {
        this.insertMana(stack);
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_6211_() {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (this.remainingManaCapacity() == 0) {
            return false;
        }
        if (stack.m_150930_((Item)HexItems.CREATIVE_UNLOCKER)) {
            return true;
        }
        int manamount = this.extractManaFromItem(stack, true);
        return manamount > 0;
    }

    public int extractManaFromItem(ItemStack stack, boolean simulate) {
        if (this.mana < 0) {
            return 0;
        }
        return ManaHelper.extractMana(stack, this.remainingManaCapacity(), true, simulate);
    }

    public void insertMana(ItemStack stack) {
        if (this.getMana() >= 0 && !stack.m_41619_() && stack.m_41720_() == HexItems.CREATIVE_UNLOCKER) {
            this.setInfiniteMana();
            stack.m_41774_(1);
        } else {
            int manamount = this.extractManaFromItem(stack, false);
            if (manamount > 0) {
                this.mana = Math.min(manamount + this.mana, 2000000000);
                this.sync();
            }
        }
    }

    public void setInfiniteMana() {
        this.mana = -1;
        this.sync();
    }

    public int remainingManaCapacity() {
        if (this.mana < 0) {
            return 0;
        }
        return Math.max(0, 2000000000 - this.mana);
    }
}

