/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.utils;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class TeleportUtils {
    public static BlockPos roundedBlockPos(Vec3 pos) {
        return new BlockPos(pos);
    }

    public static Vec3 getTeleportPos(ServerPlayer player, Vec3 playerPos, ClaimStorage storage, int[] dim, BlockPos.MutableBlockPos bPos, BiFunction<Claim, BlockPos, Boolean> check) {
        return TeleportUtils.getTeleportPos(player, playerPos, storage, dim, false, bPos, check);
    }

    public static Vec3 getTeleportPos(ServerPlayer player, Vec3 playerPos, ClaimStorage storage, int[] dim, boolean checkSub, BlockPos.MutableBlockPos bPos, BiFunction<Claim, BlockPos, Boolean> check) {
        Tuple<Direction, Vec3> pos = TeleportUtils.nearestOutside(dim, playerPos);
        bPos.m_122169_(((Vec3)pos.m_14419_()).m_7096_(), ((Vec3)pos.m_14419_()).m_7098_(), ((Vec3)pos.m_14419_()).m_7094_());
        Claim claim = storage.getClaimAt((BlockPos)bPos);
        if (checkSub) {
            Claim sub;
            Claim claim2 = sub = claim != null ? claim.getSubClaim((BlockPos)bPos) : null;
            if (sub != null) {
                claim = sub;
            }
        }
        if (claim == null || check.apply(claim, (BlockPos)bPos).booleanValue()) {
            Vec3 ret = (Vec3)pos.m_14419_();
            BlockPos rounded = TeleportUtils.roundedBlockPos(ret);
            int y = player.m_183503_().m_46819_(rounded.m_123341_() >> 4, rounded.m_123343_() >> 4, ChunkStatus.f_62325_).m_5885_(Heightmap.Types.MOTION_BLOCKING, rounded.m_123341_() & 0xF, rounded.m_123343_() & 0xF);
            Vec3 dest = new Vec3(ret.f_82479_, (double)(y + 1), ret.f_82481_);
            if (player.f_19853_.m_45756_((Entity)player, player.m_142469_().m_82383_(dest.m_82546_(player.m_20182_())))) {
                return dest;
            }
            return new Vec3((double)rounded.m_123341_() + 0.5, (double)(y + 1), (double)rounded.m_123343_() + 0.5);
        }
        int[] newDim = claim.getDimensions();
        switch ((Direction)pos.m_14418_()) {
            case NORTH: {
                dim[2] = newDim[2];
                break;
            }
            case SOUTH: {
                dim[3] = newDim[3];
                break;
            }
            case EAST: {
                dim[1] = newDim[1];
                break;
            }
            default: {
                dim[0] = newDim[0];
            }
        }
        return TeleportUtils.getTeleportPos(player, playerPos, storage, dim, checkSub, bPos, check);
    }

    private static Tuple<Direction, Vec3> nearestOutside(int[] dim, Vec3 from) {
        double northDist = Math.abs(from.m_7094_() - (double)dim[2]);
        double southDist = Math.abs((double)dim[3] - from.m_7094_());
        double westDist = Math.abs(from.m_7096_() - (double)dim[0]);
        double eastDist = Math.abs((double)dim[1] - from.m_7096_());
        if (northDist > southDist) {
            if (eastDist > westDist) {
                if (southDist > westDist) {
                    return new Tuple((Object)Direction.WEST, (Object)new Vec3((double)dim[0] - 1.5, from.m_7098_(), from.m_7094_()));
                }
                return new Tuple((Object)Direction.SOUTH, (Object)new Vec3(from.m_7096_(), from.m_7098_(), (double)dim[3] + 1.5));
            }
            if (southDist > eastDist) {
                return new Tuple((Object)Direction.EAST, (Object)new Vec3((double)dim[1] + 1.5, from.m_7098_(), from.m_7094_()));
            }
            return new Tuple((Object)Direction.SOUTH, (Object)new Vec3(from.m_7096_(), from.m_7098_(), (double)dim[3] + 1.5));
        }
        if (eastDist > westDist) {
            if (northDist > westDist) {
                return new Tuple((Object)Direction.WEST, (Object)new Vec3((double)dim[0] - 1.5, from.m_7098_(), from.m_7094_()));
            }
            return new Tuple((Object)Direction.NORTH, (Object)new Vec3(from.m_7096_(), from.m_7098_(), (double)dim[2] - 1.5));
        }
        if (northDist > eastDist) {
            return new Tuple((Object)Direction.EAST, (Object)new Vec3((double)dim[1] + 1.5, from.m_7098_(), from.m_7094_()));
        }
        return new Tuple((Object)Direction.NORTH, (Object)new Vec3(from.m_7096_(), from.m_7098_(), (double)dim[2] - 1.5));
    }
}

