/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.webmap;

import com.mojang.authlib.GameProfile;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class BluemapIntegration {
    private static final String markerID = "flan.claims";
    private static final String markerLabel = "Claims";

    public static void reg(MinecraftServer server) {
        BlueMapAPI.onEnable(api -> {
            for (ServerLevel level : server.m_129785_()) {
                api.getWorld((Object)level).ifPresent(world -> world.getMaps().forEach(map -> {
                    MarkerSet markerSet = MarkerSet.builder().label(markerLabel).build();
                    map.getMarkerSets().put(markerID, markerSet);
                }));
                BluemapIntegration.processClaims(level);
            }
            WebmapCalls.bluemapLoaded = true;
        });
    }

    public static void processClaims(ServerLevel level) {
        ClaimStorage claimStorage = ClaimStorage.get(level);
        Map<UUID, Set<Claim>> claimMap = claimStorage.getClaims();
        claimMap.forEach((uuid, claims) -> claims.forEach(BluemapIntegration::addClaimMarker));
    }

    public static void addClaimMarker(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getWorld())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                MarkerSet markerSet = (MarkerSet)map.getMarkerSets().get(markerID);
                int[] dim = claim.getDimensions();
                ExtrudeMarker marker = ((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(BluemapIntegration.claimLabel(claim))).depthTestEnabled(false).shape(Shape.createRect((double)dim[0], (double)dim[2], (double)dim[1], (double)dim[3]), (float)dim[4], (float)claim.getMaxY()).lineColor(new Color(BluemapIntegration.lineColor(claim.isAdminClaim()), 0.8f)).lineWidth(3).fillColor(new Color(BluemapIntegration.fillColor(claim.isAdminClaim()), 0.2f)).build();
                markerSet.put(claim.getClaimID().toString(), (Marker)marker);
            }
        });
    }

    public static void removeMarker(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getWorld())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                MarkerSet markerSet = (MarkerSet)map.getMarkerSets().get(markerID);
                markerSet.remove(claim.getClaimID().toString());
            }
        });
    }

    public static void changeClaimName(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getWorld())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                MarkerSet markerSet = (MarkerSet)map.getMarkerSets().get(markerID);
                Marker marker = markerSet.get(claim.getClaimID().toString());
                marker.setLabel(BluemapIntegration.claimLabel(claim));
            }
        });
    }

    public static void changeClaimOwner(Claim claim) {
        BlueMapAPI.getInstance().flatMap(api -> api.getWorld((Object)claim.getWorld())).ifPresent(world -> {
            for (BlueMapMap map : world.getMaps()) {
                MarkerSet markerSet = (MarkerSet)map.getMarkerSets().get(markerID);
                Marker marker = markerSet.get(claim.getClaimID().toString());
                marker.setLabel(BluemapIntegration.claimLabel(claim));
            }
        });
    }

    private static int lineColor(boolean admin) {
        return admin ? 11864329 : 16753152;
    }

    private static int fillColor(boolean admin) {
        return admin ? 0xFF0000 : 14737437;
    }

    private static String claimLabel(Claim claim) {
        String name = claim.getClaimName();
        if (claim.isAdminClaim()) {
            if (name == null || name.isEmpty()) {
                return "Admin Claim";
            }
            return name + " - Admin Claim";
        }
        Optional prof = claim.getWorld().m_142572_().m_129927_().m_11002_(claim.getOwner());
        if (name == null || name.isEmpty()) {
            return prof.map(GameProfile::getName).orElse("UNKNOWN") + "'s Claim";
        }
        return name + " - " + prof.map(GameProfile::getName).orElse("UNKNOWN") + "'s Claim";
    }
}

