/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.google.common.collect.Lists;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class PotionEditScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;
    private boolean removeMode;

    protected PotionEditScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
        this.claim = claim;
    }

    public static void openPotionMenu(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PotionEditScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(ConfigHandler.langManager.get("screenPotions"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Claim claim) {
        Map<MobEffect, Integer> potions = claim.getPotions();
        ArrayList key = Lists.newArrayList(potions.keySet());
        key.sort(Comparator.comparing(eff -> CrossPlatformStuff.INSTANCE.registryStatusEffects().getIDFrom((MobEffect)eff).toString()));
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 3) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenAdd"), ChatFormatting.DARK_GREEN));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= potions.size()) continue;
            MobEffect effect = (MobEffect)key.get(id);
            ItemStack effectStack = new ItemStack((ItemLike)Items.f_42589_);
            TranslatableComponent txt = new TranslatableComponent(effect.m_19481_());
            Set<MobEffectInstance> inst = Collections.singleton(new MobEffectInstance(effect, 0, potions.get(effect).intValue()));
            effectStack.m_41784_().m_128359_("FlanEffect", CrossPlatformStuff.INSTANCE.registryStatusEffects().getIDFrom(effect).toString());
            effectStack.m_41783_().m_128405_("CustomPotionColor", PotionUtils.m_43564_(inst));
            txt.m_7220_((Component)new TextComponent("-" + potions.get(effect)));
            MutableComponent comp = new TranslatableComponent(ConfigHandler.langManager.get("screenPotionText"), new Object[]{txt}).m_6270_(txt.m_7383_().m_131155_(Boolean.valueOf(false)).m_131157_(ChatFormatting.DARK_BLUE));
            effectStack.m_41714_((Component)comp);
            inv.updateStack(i, effectStack);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                String[] potion = s.split(";");
                int amp = 1;
                MobEffect effect = CrossPlatformStuff.INSTANCE.registryStatusEffects().getFromId(new ResourceLocation(potion[0]));
                if (effect == null || effect == MobEffects.f_19621_ && !potion[0].equals("minecraft:luck")) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                    return;
                }
                if (potion.length > 1) {
                    try {
                        amp = Integer.parseInt(potion[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.claim.addPotion(effect, amp);
                player.m_6915_();
                player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, this.claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_() && this.removeMode) {
            String effect = stack.m_41784_().m_128461_("FlanEffect");
            this.claim.removePotion(CrossPlatformStuff.INSTANCE.registryStatusEffects().getFromId(new ResourceLocation(effect)));
            slot.m_5852_(ItemStack.f_41583_);
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
        }
        return false;
    }
}

