/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.PersonalPermissionScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PersonalGroupScreenHandler
extends ServerOnlyScreenHandler<Object> {
    private boolean removeMode;

    private PersonalGroupScreenHandler(int syncId, Inventory playerInventory) {
        super(syncId, playerInventory, 6, null);
    }

    public static void openGroupMenu(Player player) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PersonalGroupScreenHandler(syncId, inv);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(ConfigHandler.langManager.get("screenPersonalGroups"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Object additionalData) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 3) {
                stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenAdd"), ChatFormatting.DARK_GREEN));
                inv.updateStack(i, stack);
                continue;
            }
            if (i == 4) {
                stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), ChatFormatting.DARK_RED));
                inv.updateStack(i, stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            ArrayList<String> groups = new ArrayList<String>(PlayerClaimData.get((ServerPlayer)player).playerDefaultGroups().keySet());
            groups.sort(null);
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= groups.size()) continue;
            ItemStack group = new ItemStack((ItemLike)Items.f_42516_);
            group.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenGroupName"), groups.get(id)), ChatFormatting.DARK_BLUE));
            inv.updateStack(i, group);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                PlayerClaimData.get(player).editDefaultPerms((String)s, PermissionRegistry.EDITPERMS, -1);
                player.m_6915_();
                player.m_20194_().execute(() -> PersonalGroupScreenHandler.openGroupMenu((Player)player));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> PersonalGroupScreenHandler.openGroupMenu((Player)player));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_(ServerScreenHelper.coloredGuiText(String.format(ConfigHandler.langManager.get("screenRemoveMode"), this.removeMode ? ConfigHandler.langManager.get("screenTrue") : ConfigHandler.langManager.get("screenFalse")), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            String name = stack.m_41786_().m_6111_();
            if (this.removeMode) {
                PlayerClaimData.get(player).playerDefaultGroups().remove(name);
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            } else {
                player.m_6915_();
                player.m_20194_().execute(() -> PersonalPermissionScreenHandler.openClaimMenu((Player)player, name));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return false;
    }
}

