/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimGroup;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PermissionScreenHandler
extends ServerOnlyScreenHandler<ClaimGroup> {
    private final Claim claim;
    private final String group;
    private int page;
    private int maxPages;
    private List<ClaimPermission> perms;

    private PermissionScreenHandler(int syncId, Inventory playerInventory, final Claim claim, final String group) {
        super(syncId, playerInventory, 6, new ClaimGroup(){

            @Override
            public Claim getClaim() {
                return claim;
            }

            @Override
            public String getGroup() {
                return group;
            }
        });
        this.claim = claim;
        this.group = group;
    }

    public static void openClaimMenu(Player player, final Claim claim, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PermissionScreenHandler(syncId, inv, claim, group);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(group == null ? ConfigHandler.langManager.get("screenGlobalPerms") : String.format(ConfigHandler.langManager.get("screenGroupPerms"), group), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, ClaimGroup additionalData) {
        this.perms = new ArrayList<ClaimPermission>(PermissionRegistry.getPerms());
        if (additionalData.getGroup() != null) {
            this.perms.removeAll(PermissionRegistry.globalPerms());
        }
        this.maxPages = (this.perms.size() - 1) / 28;
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                inv.updateStack(i, close);
                continue;
            }
            if (i == 51) {
                ItemStack close = new ItemStack((ItemLike)Items.f_42412_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNext"), ChatFormatting.WHITE));
                inv.updateStack(i, close);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                inv.updateStack(i, ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1;
            if (id >= this.perms.size()) continue;
            inv.updateStack(i, ServerScreenHelper.fromPermission(additionalData.getClaim(), this.perms.get(id), additionalData.getGroup() == null ? null : additionalData.getGroup()));
        }
    }

    private void flipPage() {
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(close);
                continue;
            }
            if (i == 47) {
                ItemStack stack = ServerScreenHelper.emptyFiller();
                if (this.page >= 1) {
                    stack = new ItemStack((ItemLike)Items.f_42412_);
                    stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenPrevious"), ChatFormatting.WHITE));
                }
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 51) {
                ItemStack stack = ServerScreenHelper.emptyFiller();
                if (this.page < this.maxPages) {
                    stack = new ItemStack((ItemLike)Items.f_42412_);
                    stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNext"), ChatFormatting.WHITE));
                }
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.page * 28;
            if (id < this.perms.size()) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.fromPermission(this.claim, this.perms.get(id), this.group));
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        boolean success;
        ClaimPermission perm;
        if (index == 0) {
            if (this.group == null) {
                player.m_6915_();
                player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            } else {
                player.m_6915_();
                player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, this.claim));
            }
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 47) {
            --this.page;
            this.flipPage();
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
        }
        if (index == 51) {
            ++this.page;
            this.flipPage();
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
        }
        ItemStack stack = slot.m_7993_();
        String name = stack.m_41786_().m_6111_();
        try {
            perm = PermissionRegistry.get(name);
        }
        catch (NullPointerException e) {
            return false;
        }
        if (this.group == null) {
            int mode = this.claim.parentClaim() == null ? (this.claim.permEnabled(perm) == 1 ? -1 : 1) : this.claim.permEnabled(perm) + 1;
            success = this.claim.editGlobalPerms(player, perm, mode);
        } else {
            success = this.claim.editPerms(player, this.group, perm, this.claim.groupHasPerm(this.group, perm) + 1);
        }
        slot.m_5852_(ServerScreenHelper.fromPermission(this.claim, perm, this.group));
        if (success) {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12216_, 1.0f, 1.2f);
        } else {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || this.page > 0 && slot == 47 || this.page < this.maxPages && slot == 51 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }
}

