/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ConfirmScreenHandler
extends ServerOnlyScreenHandler<Object> {
    private final Consumer<Boolean> cons;

    private ConfirmScreenHandler(int syncId, Inventory playerInventory, Consumer<Boolean> cons) {
        super(syncId, playerInventory, 1, null);
        this.cons = cons;
    }

    public static void openConfirmScreen(ServerPlayer player, final Consumer<Boolean> process) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new ConfirmScreenHandler(syncId, inv, process);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(ConfigHandler.langManager.get("screenConfirm"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Object additionalData) {
        block4: for (int i = 0; i < 9; ++i) {
            switch (i) {
                case 3: {
                    ItemStack yes = new ItemStack((ItemLike)Items.f_41936_);
                    yes.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenYes"), ChatFormatting.GREEN));
                    inv.updateStack(i, yes);
                    continue block4;
                }
                case 5: {
                    ItemStack no = new ItemStack((ItemLike)Items.f_41937_);
                    no.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenNo"), ChatFormatting.RED));
                    inv.updateStack(i, no);
                    continue block4;
                }
                default: {
                    inv.updateStack(i, ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 3 || slot == 5;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        switch (index) {
            case 3: {
                this.cons.accept(true);
                break;
            }
            case 5: {
                this.cons.accept(false);
            }
        }
        return true;
    }
}

