/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import io.github.flemmli97.flan.gui.inv.SeparateInv;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ClaimTextHandler
extends ServerOnlyScreenHandler<Claim> {
    private final Claim claim;

    private ClaimTextHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 1, claim);
        this.claim = claim;
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new ClaimTextHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return PermHelper.simpleColoredText(claim.parentClaim() != null ? ConfigHandler.langManager.get("screenTitleEditorSub") : ConfigHandler.langManager.get("screenTitleEditor"), new ChatFormatting[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith(Player player, SeparateInv inv, Claim claim) {
        block7: for (int i = 0; i < 9; ++i) {
            switch (i) {
                case 0: {
                    ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                    close.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenBack"), ChatFormatting.DARK_RED));
                    inv.updateStack(i, close);
                    continue block7;
                }
                case 2: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42438_);
                    stack.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenEnterText"), ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList<Component>();
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenTextJson"), ChatFormatting.GOLD));
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenDelete"), ChatFormatting.DARK_RED));
                    if (claim.enterTitle != null) {
                        lore.add(claim.enterTitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    inv.updateStack(i, stack);
                    continue block7;
                }
                case 3: {
                    ItemStack stack2 = new ItemStack((ItemLike)Items.f_42438_);
                    stack2.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenEnterSubText"), ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenTextJson"), ChatFormatting.GOLD));
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenDelete"), ChatFormatting.DARK_RED));
                    if (claim.enterSubtitle != null) {
                        lore.add(claim.enterSubtitle);
                    }
                    ServerScreenHelper.addLore(stack2, lore);
                    inv.updateStack(i, stack2);
                    continue block7;
                }
                case 4: {
                    ItemStack stack3 = new ItemStack((ItemLike)Items.f_42438_);
                    stack3.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenLeaveText"), ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenTextJson"), ChatFormatting.GOLD));
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenDelete"), ChatFormatting.DARK_RED));
                    if (claim.leaveTitle != null) {
                        lore.add(claim.leaveTitle);
                    }
                    ServerScreenHelper.addLore(stack3, lore);
                    inv.updateStack(i, stack3);
                    continue block7;
                }
                case 5: {
                    ItemStack stack4 = new ItemStack((ItemLike)Items.f_42438_);
                    stack4.m_41714_(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenLeaveSubText"), ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenTextJson"), ChatFormatting.GOLD));
                    lore.add(ServerScreenHelper.coloredGuiText(ConfigHandler.langManager.get("screenDelete"), ChatFormatting.DARK_RED));
                    if (claim.leaveSubtitle != null) {
                        lore.add(claim.leaveSubtitle);
                    }
                    ServerScreenHelper.addLore(stack4, lore);
                    inv.updateStack(i, stack4);
                    continue block7;
                }
                default: {
                    inv.updateStack(i, ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, this.claim));
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
        } else {
            Consumer<Component> cons;
            switch (index) {
                case 2: {
                    Consumer<Component> consumer = text -> this.claim.setEnterTitle((Component)text, this.claim.enterSubtitle);
                    break;
                }
                case 3: {
                    Consumer<Component> consumer = text -> this.claim.setEnterTitle(this.claim.enterTitle, (Component)text);
                    break;
                }
                case 4: {
                    Consumer<Component> consumer = text -> this.claim.setLeaveTitle((Component)text, this.claim.leaveSubtitle);
                    break;
                }
                case 5: {
                    Consumer<Component> consumer = text -> this.claim.setLeaveTitle(this.claim.leaveTitle, (Component)text);
                    break;
                }
                default: {
                    Consumer<Component> consumer = cons = null;
                }
            }
            if (cons != null) {
                player.m_6915_();
                Consumer<Component> finalCons = cons;
                if (clickType == 0) {
                    player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                        player.m_6915_();
                        finalCons.accept((Component)new TextComponent(s).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131157_(ChatFormatting.WHITE)));
                        player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, this.claim));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
                    }, () -> {
                        player.m_6915_();
                        player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, this.claim));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                    }));
                } else {
                    TextComponent text2 = new TextComponent(ConfigHandler.langManager.get("chatClaimTextEdit"));
                    String command = "/flan claimMessage" + (index == 2 || index == 3 ? " enter" : " leave") + (index == 2 || index == 4 ? " title" : " subtitle") + " text ";
                    text2.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                    player.m_5661_((Component)text2, false);
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return true;
    }

    private boolean hasEditPerm(Claim claim, ServerPlayer player) {
        return claim.parentClaim() != null && claim.parentClaim().canInteract(player, PermissionRegistry.EDITPERMS, player.m_142538_()) || claim.canInteract(player, PermissionRegistry.EDITPERMS, player.m_142538_());
    }

    private boolean hasPerm(Claim claim, ServerPlayer player, ClaimPermission perm) {
        if (claim.parentClaim() != null) {
            return claim.parentClaim().canInteract(player, perm, player.m_142538_());
        }
        return claim.canInteract(player, perm, player.m_142538_());
    }
}

