/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.forge.platform.integration.currency;

import dicemc.money.MoneyMod;
import dicemc.money.storage.MoneyWSD;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandCurrencyImpl
implements CommandCurrency {
    @Override
    public boolean sellClaimBlocks(ServerPlayer player, int blocks, float value, Consumer<Component> message) {
        if (value == -1.0f) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        if (Flan.diceMCMoneySign) {
            PlayerClaimData data = PlayerClaimData.get(player);
            if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
                message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("sellFail"), ChatFormatting.DARK_RED));
                return false;
            }
            double price = (float)blocks * value;
            MoneyWSD.get((ServerLevel)player.m_183503_()).changeBalance(MoneyMod.AcctTypes.PLAYER.key, player.m_142081_(), price);
            data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
            message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("sellSuccess"), blocks, price), ChatFormatting.GOLD));
            return true;
        }
        message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("currencyMissing"), ChatFormatting.DARK_RED));
        return false;
    }

    @Override
    public boolean buyClaimBlocks(ServerPlayer player, int blocks, float value, Consumer<Component> message) {
        if (value == -1.0f) {
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyDisabled"), ChatFormatting.DARK_RED));
            return false;
        }
        if (Flan.diceMCMoneySign) {
            double price;
            UUID uuid = player.m_142081_();
            MoneyWSD manager = MoneyWSD.get((ServerLevel)player.m_183503_());
            double bal = manager.getBalance(MoneyMod.AcctTypes.PLAYER.key, uuid);
            if (bal >= (price = (double)((float)blocks * value))) {
                PlayerClaimData data = PlayerClaimData.get(player);
                data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                manager.changeBalance(MoneyMod.AcctTypes.PLAYER.key, uuid, -price);
                message.accept((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("buySuccess"), blocks, price), ChatFormatting.GOLD));
                return true;
            }
            message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("buyFail"), ChatFormatting.DARK_RED));
            return false;
        }
        message.accept((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("currencyMissing"), ChatFormatting.DARK_RED));
        return false;
    }
}

