/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;

public class PlayerEvents {
    public static void saveClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).save(player.m_20194_());
        }
    }

    public static void readClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).read(player.m_20194_());
        }
    }

    public static void onLogout(Player player) {
        if (player.m_20194_() != null) {
            LogoutTracker.getInstance(player.m_20194_()).track(player.m_142081_());
        }
    }

    public static boolean growBonemeal(UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState state = serverPlayer.f_19853_.m_8055_(context.m_8083_());
            BlockPos.MutableBlockPos pos = context.m_8083_().m_122032_();
            ClaimPermission perm = ObjectToPermissionMap.getFromItem(context.m_43722_().m_41720_());
            if (!ClaimStorage.get(serverPlayer.m_183503_()).getForPermissionCheck((BlockPos)pos).canInteract(serverPlayer, perm, (BlockPos)pos, false)) {
                return false;
            }
            int range = 0;
            if (state.m_60734_() instanceof MossBlock) {
                VegetationPatchConfiguration cfg = (VegetationPatchConfiguration)((ConfiguredFeature)CaveFeatures.f_194951_.m_203334_()).f_65378_();
                range = cfg.f_161289_.m_142737_() + 1;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_161287_ + 1, pos.m_123343_());
            } else if (state.m_60734_() instanceof GrassBlock) {
                range = 4;
            } else if (state.m_60713_(Blocks.f_50699_)) {
                NetherForestVegetationConfig cfg = (NetherForestVegetationConfig)((ConfiguredFeature)NetherFeatures.f_195037_.m_203334_()).f_65378_();
                range = cfg.f_191259_;
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_191260_ + 1, pos.m_123343_());
            } else if (state.m_60713_(Blocks.f_50690_)) {
                NetherForestVegetationConfig cfg = (NetherForestVegetationConfig)((ConfiguredFeature)NetherFeatures.f_195040_.m_203334_()).f_65378_();
                NetherForestVegetationConfig cfg2 = (NetherForestVegetationConfig)((ConfiguredFeature)NetherFeatures.f_195042_.m_203334_()).f_65378_();
                TwistingVinesConfig cfg3 = (TwistingVinesConfig)((ConfiguredFeature)NetherFeatures.f_195044_.m_203334_()).f_65378_();
                range = Math.max(Math.max(cfg.f_191259_, cfg2.f_191259_), cfg3.f_191365_());
                int y = Math.max(Math.max(cfg.f_191260_, cfg2.f_191260_), cfg3.f_191366_());
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + y + 1, pos.m_123343_());
            }
            if (range > 0 && perm != null && !ClaimStorage.get(serverPlayer.m_183503_()).canInteract((BlockPos)pos, range, serverPlayer, perm, false)) {
                serverPlayer.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("tooCloseClaim"), ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }
}

