/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class CommandHelpers {
    private static final Pattern allowed = Pattern.compile("[a-zA-Z0-9_+.-]+");

    public static CompletableFuture<Suggestions> claimSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder build, UUID owner) {
        return SharedSuggestionProvider.m_82970_((Iterable)ClaimStorage.get(((CommandSourceStack)context.getSource()).m_81372_()).allClaimsFromPlayer(owner).stream().map(claim -> claim.getClaimName().isEmpty() ? claim.getClaimID().toString() : claim.getClaimName()).collect(Collectors.toList()), (SuggestionsBuilder)build);
    }

    public static GameProfile singleProfile(CommandContext<CommandSourceStack> context, String arg) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.m_94590_(context, (String)arg);
        if (profs.size() != 1) {
            throw new SimpleCommandExceptionType(() -> ConfigHandler.langManager.get("onlyOnePlayer")).create();
        }
        return (GameProfile)profs.stream().findFirst().get();
    }

    public static CompletableFuture<Suggestions> permSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder build, boolean group) {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        Claim claim = ClaimStorage.get(world).getClaimAt(new BlockPos(((CommandSourceStack)context.getSource()).m_81371_()));
        boolean admin = claim != null && claim.isAdminClaim();
        ArrayList<String> allowedPerms = new ArrayList<String>();
        for (ClaimPermission perm : PermissionRegistry.getPerms()) {
            if (!admin && ConfigHandler.config.globallyDefined(world, perm) || group && PermissionRegistry.globalPerms().contains(perm)) continue;
            allowedPerms.add(perm.id);
        }
        return SharedSuggestionProvider.m_82970_(allowedPerms, (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> groupSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        List<Object> list = new ArrayList();
        ClaimStorage storage = ClaimStorage.get(player.m_183503_());
        Claim claim = storage.getClaimAt(player.m_142538_());
        if (claim != null && claim.canInteract(player, PermissionRegistry.EDITPERMS, player.m_142538_())) {
            list = claim.groups();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (allowed.matcher((CharSequence)list.get(i)).matches()) continue;
            list.set(i, "\"" + (String)list.get(i) + "\"");
        }
        return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> personalGroupSuggestion(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ArrayList<String> list = new ArrayList<String>(PlayerClaimData.get(player).playerDefaultGroups().keySet());
        list.sort(null);
        for (int i = 0; i < list.size(); ++i) {
            if (allowed.matcher((CharSequence)list.get(i)).matches()) continue;
            list.set(i, "\"" + (String)list.get(i) + "\"");
        }
        return SharedSuggestionProvider.m_82970_(list, (SuggestionsBuilder)build);
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> clss, String name, T fallback) {
        try {
            return Enum.valueOf(clss, name);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    public static <T extends Enum<T>> CompletableFuture<Suggestions> enumSuggestion(Class<T> clss, SuggestionsBuilder build) {
        return SharedSuggestionProvider.m_82981_(Stream.of((Enum[])clss.getEnumConstants()).map(Object::toString), (SuggestionsBuilder)build);
    }
}

