/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class CommandHelp {
    public static int helpMessage(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return CommandHelp.helpMessage(context, page, nodes);
    }

    public static int helpMessage(CommandContext<CommandSourceStack> context, int page, Collection<CommandNode<CommandSourceStack>> nodes) {
        List<String> subCommands = CommandHelp.registeredCommands(context, nodes);
        subCommands.remove("?");
        int max = subCommands.size() / 8;
        if (page > max) {
            page = max;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("helpHeader"), page), ChatFormatting.GOLD), false);
        for (int i = 8 * page; i < 8 * (page + 1); ++i) {
            if (i >= subCommands.size()) continue;
            MutableComponent cmdText = PermHelper.simpleColoredText("- " + subCommands.get(i), ChatFormatting.GRAY);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)cmdText.m_130948_(cmdText.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help cmd " + subCommands.get(i)))), false);
        }
        MutableComponent pageText = PermHelper.simpleColoredText((page > 0 ? "  " : "") + " ", ChatFormatting.DARK_GREEN);
        if (page > 0) {
            MutableComponent pageTextBack = PermHelper.simpleColoredText("<<", ChatFormatting.DARK_GREEN);
            pageTextBack.m_130948_(pageTextBack.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page - 1))));
            pageText = pageTextBack.m_7220_((Component)pageText);
        }
        if (page < max) {
            MutableComponent pageTextNext = PermHelper.simpleColoredText(">>", new ChatFormatting[0]);
            pageTextNext.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page + 1))));
            pageText = pageText.m_7220_((Component)pageTextNext);
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)pageText, false);
        return 1;
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context) {
        String command = StringArgumentType.getString(context, (String)"command");
        return CommandHelp.helpCmd(context, command);
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context, String command) {
        String[] cmdHelp = ConfigHandler.langManager.getArray("command." + command);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("helpCmdHeader"), ChatFormatting.DARK_GREEN), false);
        for (int i = 0; i < cmdHelp.length; ++i) {
            if (i == 0) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("helpCmdSyntax"), cmdHelp[i]), ChatFormatting.GOLD), false);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText("", new ChatFormatting[0]), false);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText(cmdHelp[i], ChatFormatting.GOLD), false);
        }
        if (command.equals("help")) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("wiki"), ChatFormatting.GOLD), false);
            MutableComponent wiki = PermHelper.simpleColoredText("https://github.com/Flemmli97/Flan/wiki", ChatFormatting.GREEN);
            wiki.m_6270_(wiki.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Flemmli97/Flan/wiki")));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)wiki, false);
        }
        return 1;
    }

    public static List<String> registeredCommands(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        return nodes.stream().filter(node -> node.canUse((Object)((CommandSourceStack)context.getSource()))).map(CommandNode::getName).collect(Collectors.toList());
    }
}

