/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.data.IPermissionStorage;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionRegistry;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.GlobalClaim;
import io.github.flemmli97.flan.claim.IClaimStorage;
import io.github.flemmli97.flan.claim.PermHelper;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.claiming.OtherClaimingModCheck;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import io.github.flemmli97.flan.player.EnumEditMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.PlayerDataHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.shadow.org.yaml.snakeyaml.Yaml;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class ClaimStorage
implements IPermissionStorage {
    public static final String adminClaimString = "!AdminClaims";
    private final Long2ObjectMap<List<Claim>> claims = new Long2ObjectOpenHashMap();
    private final Map<UUID, Claim> claimUUIDMap = new HashMap<UUID, Claim>();
    private final Map<UUID, Set<Claim>> playerClaimMap = new HashMap<UUID, Set<Claim>>();
    private final Set<UUID> dirty = new HashSet<UUID>();
    private final GlobalClaim globalClaim;

    public static ClaimStorage get(ServerLevel world) {
        return ((IClaimStorage)world).get();
    }

    public ClaimStorage(MinecraftServer server, ServerLevel world) {
        this.globalClaim = new GlobalClaim(world);
        this.read(server, world);
        PlayerDataHandler.deleteUnusedClaims(server, this, world);
    }

    public UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        if (this.claimUUIDMap.containsKey(uuid)) {
            return this.generateUUID();
        }
        return uuid;
    }

    public Claim createAdminClaim(BlockPos pos1, BlockPos pos2, ServerLevel level) {
        Claim claim = new Claim(pos1.m_6625_(ConfigHandler.config.defaultClaimDepth), pos2.m_6625_(ConfigHandler.config.defaultClaimDepth), null, level);
        Set<DisplayBox> conflicts = this.conflicts(claim, null);
        if (conflicts.isEmpty()) {
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new admin claim {}", claim);
            this.addClaim(claim);
            return claim;
        }
        return null;
    }

    public boolean createClaim(BlockPos pos1, BlockPos pos2, ServerPlayer player) {
        Claim claim = new Claim(pos1.m_6625_(ConfigHandler.config.defaultClaimDepth), pos2.m_6625_(ConfigHandler.config.defaultClaimDepth), player);
        Set<DisplayBox> conflicts = this.conflicts(claim, null);
        if (conflicts.isEmpty()) {
            PlayerClaimData data = PlayerClaimData.get(player);
            if (claim.getPlane() < ConfigHandler.config.minClaimsize) {
                player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("minClaimSize"), ConfigHandler.config.minClaimsize), ChatFormatting.RED), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && ConfigHandler.config.maxClaims != -1 && !PermissionNodeHandler.INSTANCE.permBelowEqVal(player, "flan.claims.amount", this.playerClaimMap.getOrDefault(player.m_142081_(), Sets.newHashSet()).size() + 1, ConfigHandler.config.maxClaims)) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("maxClaims"), ChatFormatting.RED), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && !data.canUseClaimBlocks(claim.getPlane())) {
                player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("notEnoughBlocks"), ChatFormatting.RED), false);
                return false;
            }
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new claim {}", claim);
            this.addClaim(claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
            data.updateScoreboard();
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("claimCreateSuccess"), ChatFormatting.GOLD), false);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimBlocksFormat"), data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD), false);
            return true;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        conflicts.forEach(conf -> data.addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.m_142538_().m_123342_()));
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("conflictOther"), ChatFormatting.RED), false);
        return false;
    }

    private Set<DisplayBox> conflicts(Claim claim, Claim except) {
        HashSet<DisplayBox> conflicted = new HashSet<DisplayBox>();
        int[] chunks = ClaimStorage.getChunkPos(claim);
        for (int x = chunks[0]; x <= chunks[1]; ++x) {
            for (int z = chunks[2]; z <= chunks[3]; ++z) {
                List claims = (List)this.claims.get(ChunkPos.m_45589_((int)x, (int)z));
                if (claims == null) continue;
                for (Claim other : claims) {
                    if (!claim.intersects(other) || other.equals(except)) continue;
                    conflicted.add(other.display());
                }
            }
        }
        if (!claim.isAdminClaim()) {
            OtherClaimingModCheck.INSTANCE.findConflicts(claim, conflicted);
        }
        return conflicted;
    }

    public boolean deleteClaim(Claim claim, boolean updateClaim, EnumEditMode mode, ServerLevel world) {
        if (mode == EnumEditMode.SUBCLAIM) {
            if (claim.parentClaim() != null) {
                return claim.parentClaim().deleteSubClaim(claim);
            }
            return false;
        }
        Flan.log("Try deleting claim {}", claim);
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.compute(ChunkPos.m_45589_((int)x, (int)z), (key, val) -> {
                    if (val == null) {
                        return null;
                    }
                    val.remove(claim);
                    return val.isEmpty() ? null : val;
                });
            }
        }
        ((Set)this.playerClaimMap.getOrDefault(claim.getOwner(), new HashSet())).remove(claim);
        this.dirty.add(claim.getOwner());
        if (updateClaim) {
            claim.remove();
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        WebmapCalls.removeMarker(claim);
        return this.claimUUIDMap.remove(claim.getClaimID()) != null;
    }

    public void toggleAdminClaim(ServerPlayer player, Claim claim, boolean toggle) {
        Flan.log("Set claim {} to an admin claim", claim);
        this.deleteClaim(claim, false, EnumEditMode.DEFAULT, player.m_183503_());
        if (toggle) {
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        claim.toggleAdminClaim(player, toggle);
        if (!toggle) {
            PlayerClaimData.get(player).updateScoreboard();
        }
        this.addClaim(claim);
    }

    public boolean resizeClaim(Claim claim, BlockPos from, BlockPos to, ServerPlayer player) {
        boolean enoughBlocks;
        int[] dims = claim.getDimensions();
        BlockPos opposite = new BlockPos(dims[0] == from.m_123341_() ? dims[1] : dims[0], dims[4], dims[2] == from.m_123343_() ? dims[3] : dims[2]);
        Claim newClaim = new Claim(opposite, to, player.m_142081_(), player.m_183503_());
        if (newClaim.getPlane() < ConfigHandler.config.minClaimsize) {
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("minClaimSize"), ConfigHandler.config.minClaimsize), ChatFormatting.RED), false);
            return false;
        }
        Set<DisplayBox> conflicts = this.conflicts(newClaim, claim);
        if (!conflicts.isEmpty()) {
            conflicts.forEach(conf -> PlayerClaimData.get(player).addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.m_142538_().m_123342_()));
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("conflictOther"), ChatFormatting.RED), false);
            return false;
        }
        int diff = newClaim.getPlane() - claim.getPlane();
        PlayerClaimData data = PlayerClaimData.get(player);
        IPlayerData newData = claim.getOwnerPlayer().map(o -> {
            if (o == player || claim.isAdminClaim()) {
                return data;
            }
            return PlayerClaimData.get(o);
        }).orElse(new OfflinePlayerData(player.m_20194_(), claim.getOwner()));
        boolean bl = enoughBlocks = claim.isAdminClaim() || data.isAdminIgnoreClaim() || newData.canUseClaimBlocks(diff);
        if (enoughBlocks) {
            Flan.log("Resizing claim {}", claim);
            this.deleteClaim(claim, false, EnumEditMode.DEFAULT, player.m_183503_());
            claim.copySizes(newClaim);
            this.addClaim(claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_142538_().m_123342_());
            if (newData instanceof PlayerClaimData) {
                ((PlayerClaimData)newData).updateScoreboard();
            }
            player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("resizeSuccess"), ChatFormatting.GOLD), false);
            player.m_5661_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("claimBlocksFormat"), newData.getClaimBlocks(), newData.getAdditionalClaims(), newData.usedClaimBlocks(), data.remainingClaimBlocks()), ChatFormatting.GOLD), false);
            return true;
        }
        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("notEnoughBlocks"), ChatFormatting.RED), false);
        return false;
    }

    public Claim getClaimAt(BlockPos pos) {
        long chunk = ChunkPos.m_45589_((int)(pos.m_123341_() >> 4), (int)(pos.m_123343_() >> 4));
        List list = (List)this.claims.get(chunk);
        if (list != null) {
            for (Claim claim : list) {
                if (!claim.insideClaim(pos)) continue;
                return claim;
            }
        }
        return null;
    }

    public List<Claim> getClaimsAt(int chunkX, int chunkZ) {
        return (List)this.claims.getOrDefault(ChunkPos.m_45589_((int)chunkX, (int)chunkZ), Collections.emptyList());
    }

    @Override
    public IPermissionContainer getForPermissionCheck(BlockPos pos) {
        Claim claim = this.getClaimAt(pos);
        if (claim != null) {
            return claim;
        }
        return this.globalClaim;
    }

    public boolean canInteract(BlockPos pos, int radius, ServerPlayer player, ClaimPermission perm, boolean message) {
        boolean realPlayer = player != null && player.getClass().equals(ServerPlayer.class);
        message = message && realPlayer;
        ChunkPos c = new ChunkPos(new BlockPos(pos.m_123341_() - radius, pos.m_123342_(), pos.m_123343_() - radius));
        ArrayList affected = new ArrayList();
        int x = 0;
        while (SectionPos.m_123223_((int)(c.f_45578_ + x)) <= pos.m_123341_() + radius) {
            int z = 0;
            while (SectionPos.m_123223_((int)(c.f_45579_ + z)) <= pos.m_123343_() + radius) {
                List list = (List)this.claims.get(ChunkPos.m_45589_((int)(c.f_45578_ + x), (int)(c.f_45579_ + z)));
                if (list != null) {
                    affected.addAll((Collection)this.claims.get(ChunkPos.m_45589_((int)(c.f_45578_ + x), (int)(c.f_45579_ + z))));
                }
                ++z;
            }
            ++x;
        }
        Claim last = null;
        for (BlockPos ipos : BlockPos.m_121976_((int)(pos.m_123341_() - radius), (int)pos.m_123342_(), (int)(pos.m_123343_() - radius), (int)(pos.m_123341_() + radius), (int)pos.m_123342_(), (int)(pos.m_123343_() + radius))) {
            if (last != null) {
                if (last.insideClaim(ipos)) {
                    if (last.canInteract(player, perm, ipos, false)) continue;
                    if (message) {
                        player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermissionTooClose"), ChatFormatting.DARK_RED), true);
                    }
                    return false;
                }
                last = null;
            }
            for (Claim claim : affected) {
                if (!claim.insideClaim(ipos)) continue;
                last = claim;
                if (claim.canInteract(player, perm, ipos, message)) continue;
                if (message) {
                    player.m_5661_((Component)PermHelper.simpleColoredText(ConfigHandler.langManager.get("noPermissionTooClose"), ChatFormatting.DARK_RED), true);
                }
                return false;
            }
        }
        return true;
    }

    public Claim getFromUUID(UUID uuid) {
        return this.claimUUIDMap.get(uuid);
    }

    private void addClaim(Claim claim) {
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.merge(ChunkPos.m_45589_((int)x, (int)z), (Object)Lists.newArrayList((Object[])new Claim[]{claim}), (old, val) -> {
                    old.add(claim);
                    return old;
                });
            }
        }
        this.claimUUIDMap.put(claim.getClaimID(), claim);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        WebmapCalls.addClaimMarker(claim);
    }

    public boolean transferOwner(Claim claim, ServerPlayer player, UUID newOwner) {
        if (!PlayerClaimData.get(player).isAdminIgnoreClaim() && !player.m_142081_().equals(claim.getOwner())) {
            return false;
        }
        return this.transferOwner(claim, newOwner);
    }

    public boolean transferOwner(Claim claim, UUID newOwner) {
        this.playerClaimMap.merge(claim.getOwner(), new HashSet(), (old, val) -> {
            old.remove(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        claim.transferOwner(newOwner);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        WebmapCalls.changeClaimOwner(claim);
        return true;
    }

    public Collection<Claim> allClaimsFromPlayer(UUID player) {
        return this.playerClaimMap.containsKey(player) ? ImmutableSet.copyOf((Collection)this.playerClaimMap.get(player)) : ImmutableSet.of();
    }

    public Collection<Claim> getAdminClaims() {
        return ImmutableSet.copyOf((Collection)this.playerClaimMap.get(null));
    }

    public Map<UUID, Set<Claim>> getClaims() {
        return this.playerClaimMap;
    }

    public static int[] getChunkPos(Claim claim) {
        int[] dim = claim.getDimensions();
        int[] pos = new int[]{dim[0] >> 4, dim[1] >> 4, dim[2] >> 4, dim[3] >> 4};
        return pos;
    }

    public void read(MinecraftServer server, ServerLevel world) {
        Flan.log("Loading claim data for world {}", world.m_46472_());
        Path dir = ConfigHandler.getClaimSavePath(server, (ResourceKey<Level>)world.m_46472_());
        if (Files.exists(dir, new LinkOption[0])) {
            try {
                for (Path file : Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet())) {
                    String name = file.toFile().getName();
                    if (!name.endsWith(".json")) continue;
                    String realName = name.replace(".json", "");
                    UUID uuid = realName.equals(adminClaimString) ? null : UUID.fromString(realName);
                    JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
                    JsonArray arr = (JsonArray)ConfigHandler.GSON.fromJson(reader, JsonArray.class);
                    reader.close();
                    if (arr == null) continue;
                    Flan.debug("Reading claim data from json {} for player uuid {}", arr, uuid);
                    arr.forEach(el -> {
                        if (el.isJsonObject()) {
                            this.addClaim(Claim.fromJson((JsonObject)el, uuid, world));
                        }
                    });
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(MinecraftServer server, ResourceKey<Level> reg) {
        Flan.log("Saving claims for world {}", reg);
        Path dir = ConfigHandler.getClaimSavePath(server, reg);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (Map.Entry<UUID, Set<Claim>> e : this.playerClaimMap.entrySet()) {
                String owner = e.getKey() == null ? adminClaimString : e.getKey().toString();
                Path file = dir.resolve(owner + ".json");
                Flan.debug("Attempting saving claim data for player uuid {}", owner);
                boolean dirty = false;
                if (!Files.exists(file, new LinkOption[0])) {
                    if (e.getValue().isEmpty()) continue;
                    Files.createFile(file, new FileAttribute[0]);
                    dirty = true;
                } else {
                    if (e.getValue().isEmpty()) {
                        Files.delete(file);
                        continue;
                    }
                    if (this.dirty.remove(owner.equals(adminClaimString) ? null : e.getKey())) {
                        dirty = true;
                    } else {
                        for (Claim claim2 : e.getValue()) {
                            if (!claim2.isDirty()) continue;
                            dirty = true;
                            claim2.setDirty(false);
                        }
                    }
                }
                if (!dirty) continue;
                JsonArray arr = new JsonArray();
                e.getValue().forEach(claim -> arr.add((JsonElement)claim.toJson(new JsonObject())));
                Flan.debug("Attempting saving changed claim data {} for player uuid {}", arr, owner);
                JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
                ConfigHandler.GSON.toJson((JsonElement)arr, jsonWriter);
                jsonWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean readGriefPreventionData(MinecraftServer server, CommandSourceStack src) {
        Yaml yml = new Yaml();
        File griefPrevention = server.m_129843_(LevelResource.f_78182_).resolve("plugins/GriefPreventionData/ClaimData").toFile();
        if (!griefPrevention.exists()) {
            src.m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("cantFindData"), griefPrevention.getAbsolutePath()), ChatFormatting.DARK_RED), false);
            return false;
        }
        HashMap<File, List> subClaimMap = new HashMap<File, List>();
        HashMap<Integer, File> intFileMap = new HashMap<Integer, File>();
        Set<ClaimPermission> managers = ClaimStorage.complementOf(PermissionRegistry.EDITCLAIM);
        Set<ClaimPermission> builders = ClaimStorage.complementOf(PermissionRegistry.EDITPERMS, PermissionRegistry.EDITCLAIM);
        Set<ClaimPermission> containers = ClaimStorage.complementOf(PermissionRegistry.EDITPERMS, PermissionRegistry.EDITCLAIM, PermissionRegistry.BREAK, PermissionRegistry.PLACE, PermissionRegistry.NOTEBLOCK, PermissionRegistry.REDSTONE, PermissionRegistry.JUKEBOX, PermissionRegistry.ITEMFRAMEROTATE, PermissionRegistry.LECTERNTAKE, PermissionRegistry.ENDCRYSTALPLACE, PermissionRegistry.PROJECTILES, PermissionRegistry.TRAMPLE, PermissionRegistry.RAID, PermissionRegistry.BUCKET, PermissionRegistry.ARMORSTAND, PermissionRegistry.BREAKNONLIVING);
        Set<ClaimPermission> accessors = ClaimStorage.complementOf(PermissionRegistry.EDITPERMS, PermissionRegistry.EDITCLAIM, PermissionRegistry.BREAK, PermissionRegistry.PLACE, PermissionRegistry.OPENCONTAINER, PermissionRegistry.ANVIL, PermissionRegistry.BEACON, PermissionRegistry.NOTEBLOCK, PermissionRegistry.REDSTONE, PermissionRegistry.JUKEBOX, PermissionRegistry.ITEMFRAMEROTATE, PermissionRegistry.LECTERNTAKE, PermissionRegistry.ENDCRYSTALPLACE, PermissionRegistry.PROJECTILES, PermissionRegistry.TRAMPLE, PermissionRegistry.RAID, PermissionRegistry.BUCKET, PermissionRegistry.ANIMALINTERACT, PermissionRegistry.HURTANIMAL, PermissionRegistry.TRADING, PermissionRegistry.ARMORSTAND, PermissionRegistry.BREAKNONLIVING);
        HashMap<String, Set<ClaimPermission>> perms = new HashMap<String, Set<ClaimPermission>>();
        perms.put("managers", managers);
        perms.put("builders", builders);
        perms.put("containers", containers);
        perms.put("accessors", accessors);
        try {
            Object reader;
            Map values;
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || !(values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                try {
                    intFileMap.put(Integer.valueOf(f.getName().replace(".yml", "")), f);
                }
                catch (NumberFormatException e) {
                    src.m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("errorFile"), f.getName(), ChatFormatting.RED), new ChatFormatting[0]), false);
                }
            }
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || (values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                subClaimMap.merge((File)intFileMap.get(Integer.valueOf(values.get("Parent Claim ID").toString())), Lists.newArrayList((Object[])new File[]{f}), (key, val) -> {
                    key.add(f);
                    return key;
                });
            }
            for (File parent : intFileMap.values()) {
                try {
                    ClaimStorage storage;
                    Set<DisplayBox> conflicts;
                    Tuple<ServerLevel, Claim> parentClaim = ClaimStorage.parseFromYaml(parent, yml, server, perms);
                    List childs = (List)subClaimMap.get(parent);
                    if (childs != null && !childs.isEmpty()) {
                        for (File childF : childs) {
                            ((Claim)parentClaim.m_14419_()).addSubClaimGriefprevention((Claim)ClaimStorage.parseFromYaml(childF, yml, server, perms).m_14419_());
                        }
                    }
                    if ((conflicts = (storage = ClaimStorage.get((ServerLevel)parentClaim.m_14418_())).conflicts((Claim)parentClaim.m_14419_(), null)).isEmpty()) {
                        ((Claim)parentClaim.m_14419_()).setClaimID(storage.generateUUID());
                        storage.addClaim((Claim)parentClaim.m_14419_());
                        continue;
                    }
                    src.m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("readConflict"), parent.getName(), conflicts), ChatFormatting.DARK_RED), false);
                    for (DisplayBox claim : conflicts) {
                        DisplayBox.Box dim = claim.box();
                        MutableComponent text = PermHelper.simpleColoredText(String.format("@[x=%d;z=%d]", dim.minX(), dim.minZ()), ChatFormatting.RED);
                        text.m_6270_(text.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + dim.minX() + " ~ " + dim.minZ())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
                        src.m_81354_((Component)text, false);
                    }
                }
                catch (Exception e) {
                    src.m_81354_((Component)PermHelper.simpleColoredText(String.format(ConfigHandler.langManager.get("errorFile"), parent.getName(), ChatFormatting.RED), new ChatFormatting[0]), false);
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static Set<ClaimPermission> complementOf(ClaimPermission ... perms) {
        HashSet set = Sets.newHashSet(PermissionRegistry.getPerms());
        for (ClaimPermission perm : perms) {
            set.remove(perm);
        }
        return set;
    }

    private static Tuple<ServerLevel, Claim> parseFromYaml(File file, Yaml yml, MinecraftServer server, Map<String, Set<ClaimPermission>> perms) throws IOException {
        FileReader reader = new FileReader(file);
        Map values = (Map)yml.load(reader);
        reader.close();
        String ownerString = (String)values.get("Owner");
        UUID owner = ownerString.isEmpty() ? null : UUID.fromString(ownerString);
        List<String> builders = ClaimStorage.readList(values, "Builders");
        List<String> managers = ClaimStorage.readList(values, "Managers");
        List<String> containers = ClaimStorage.readList(values, "Containers");
        List<String> accessors = ClaimStorage.readList(values, "Accessors");
        String[] lesserCorner = values.get("Lesser Boundary Corner").toString().split(";");
        String[] greaterCorner = values.get("Greater Boundary Corner").toString().split(";");
        ServerLevel world = server.m_129880_(ClaimStorage.worldRegFromString(lesserCorner[0]));
        Claim claim = new Claim(Integer.parseInt(lesserCorner[1]), Integer.parseInt(greaterCorner[1]), Integer.parseInt(lesserCorner[3]), Integer.parseInt(greaterCorner[3]), ConfigHandler.config.defaultClaimDepth == 255 ? 0 : Integer.parseInt(lesserCorner[2]), owner, world);
        if (!builders.isEmpty() && !builders.contains(ownerString)) {
            if (builders.contains("public")) {
                perms.get("builders").forEach(perm -> {
                    if (!PermissionRegistry.globalPerms().contains(perm)) {
                        claim.editGlobalPerms(null, (ClaimPermission)perm, 1);
                    }
                });
            } else {
                perms.get("builders").forEach(perm -> claim.editPerms(null, "Builders", (ClaimPermission)perm, 1, true));
                builders.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Builders", true));
            }
        }
        if (!managers.isEmpty() && !managers.contains(ownerString)) {
            if (managers.contains("public")) {
                perms.get("managers").forEach(perm -> {
                    if (!PermissionRegistry.globalPerms().contains(perm)) {
                        claim.editGlobalPerms(null, (ClaimPermission)perm, 1);
                    }
                });
            } else {
                perms.get("managers").forEach(perm -> claim.editPerms(null, "Managers", (ClaimPermission)perm, 1, true));
                managers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Managers", true));
            }
        }
        if (!containers.isEmpty() && !containers.contains(ownerString)) {
            if (containers.contains("public")) {
                perms.get("containers").forEach(perm -> {
                    if (!PermissionRegistry.globalPerms().contains(perm)) {
                        claim.editGlobalPerms(null, (ClaimPermission)perm, 1);
                    }
                });
            } else {
                perms.get("containers").forEach(perm -> claim.editPerms(null, "Containers", (ClaimPermission)perm, 1, true));
                containers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Containers", true));
            }
        }
        if (!accessors.isEmpty() && !accessors.contains(ownerString)) {
            if (accessors.contains("public")) {
                perms.get("accessors").forEach(perm -> {
                    if (!PermissionRegistry.globalPerms().contains(perm)) {
                        claim.editGlobalPerms(null, (ClaimPermission)perm, 1);
                    }
                });
            } else {
                perms.get("accessors").forEach(perm -> claim.editPerms(null, "Accessors", (ClaimPermission)perm, 1, true));
                accessors.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Accessors", true));
            }
        }
        return new Tuple((Object)world, (Object)claim);
    }

    private static <T> List<T> readList(Map<String, Object> values, String key) {
        Object obj = values.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return new ArrayList();
    }

    public static ResourceKey<Level> worldRegFromString(String spigot) {
        if (spigot.equals("world_the_end")) {
            return Level.f_46430_;
        }
        if (spigot.equals("world_nether")) {
            return Level.f_46429_;
        }
        return Level.f_46428_;
    }
}

