/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.camera;

import com.hollingsworth.arsnouveau.api.camera.ICameraMountable;
import com.hollingsworth.arsnouveau.client.ClientHandler;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class CameraEvents {
    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        Entity entity = player.m_8954_();
        if (entity instanceof ScryerCamera) {
            ScryerCamera cam = (ScryerCamera)entity;
            BlockEntity blockEntity = player.f_19853_.m_7702_(cam.m_142538_());
            if (blockEntity instanceof ICameraMountable) {
                ICameraMountable camBe = (ICameraMountable)blockEntity;
                camBe.stopViewing();
            }
            cam.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (CameraUtil.isPlayerMountedOnCamera(entity)) {
                ((ScryerCamera)player.m_8954_()).stopViewing(player);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onGuiOpen(ScreenOpenEvent event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen || screen instanceof JoinMultiplayerScreen) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ClientHandler.cameraOverlay, (boolean)false);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.JUMP_BAR_ELEMENT, (boolean)true);
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.EXPERIENCE_BAR_ELEMENT, (boolean)true);
        }
    }
}

