/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.util.JsonHelper;

public class SetBlockPredicate
implements BlockPredicate {
    private final Set<Block> blocks;
    public static final GenericLoaderRegistry.IGenericLoader<SetBlockPredicate> LOADER = new GenericLoaderRegistry.IGenericLoader<SetBlockPredicate>(){

        @Override
        public SetBlockPredicate deserialize(JsonObject json) {
            ImmutableSet blocks = ImmutableSet.copyOf(JsonHelper.parseList(json, "blocks", (element, key) -> {
                ResourceLocation name = JsonHelper.convertToResourceLocation(element, key);
                return (Block)Registry.f_122824_.m_6612_(name).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + name + "'"));
            }));
            return new SetBlockPredicate((Set<Block>)blocks);
        }

        @Override
        public SetBlockPredicate fromNetwork(FriendlyByteBuf buffer) {
            ImmutableSet.Builder blocks = ImmutableSet.builder();
            int max = buffer.m_130242_();
            for (int i = 0; i < max; ++i) {
                blocks.add((Object)((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS)));
            }
            return new SetBlockPredicate((Set<Block>)blocks.build());
        }

        @Override
        public void serialize(SetBlockPredicate object, JsonObject json) {
            JsonArray blocksJson = new JsonArray();
            for (Block block : object.blocks) {
                blocksJson.add(Objects.requireNonNull(block.getRegistryName()).toString());
            }
            json.add("blocks", (JsonElement)blocksJson);
        }

        @Override
        public void toNetwork(SetBlockPredicate object, FriendlyByteBuf buffer) {
            buffer.m_130130_(object.blocks.size());
            for (Block block : object.blocks) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (IForgeRegistryEntry)block);
            }
        }
    };

    @Override
    public boolean matches(BlockState state) {
        return this.blocks.contains(state.m_60734_());
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends BlockPredicate> getLoader() {
        return LOADER;
    }

    public SetBlockPredicate(Set<Block> blocks) {
        this.blocks = blocks;
    }
}

