/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle;

import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.config.Config;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.block.SetBlockPredicate;
import slimeknights.mantle.data.predicate.block.TagBlockPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.entity.MobTypePredicate;
import slimeknights.mantle.data.predicate.entity.TagEntityPredicate;
import slimeknights.mantle.datagen.MantleFluidTagProvider;
import slimeknights.mantle.datagen.MantleFluidTooltipProvider;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.transfer.EmptyFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.EmptyFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidContainerTransfer;
import slimeknights.mantle.fluid.transfer.FillFluidWithNBTTransfer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.item.LecternBookItem;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.recipe.crafting.ShapedFallbackRecipe;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipe;
import slimeknights.mantle.recipe.helper.TagEmptyCondition;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.recipe.ingredient.FluidContainerIngredient;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;
import slimeknights.mantle.util.OffhandCooldownTracker;

@Mod(value="mantle")
public class Mantle {
    public static final String modId = "mantle";
    public static final Logger logger = LogManager.getLogger((String)"Mantle");
    public static Mantle instance;

    public Mantle() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        FluidContainerTransferManager.INSTANCE.init();
        MantleTags.init();
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventPriority.NORMAL, false, FMLCommonSetupEvent.class, this::commonSetup);
        bus.addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, this::registerCapabilities);
        bus.addListener(EventPriority.NORMAL, false, GatherDataEvent.class, this::gatherData);
        bus.addGenericListener(RecipeSerializer.class, this::registerRecipeSerializers);
        bus.addGenericListener(BlockEntityType.class, this::registerBlockEntities);
        bus.addGenericListener(GlobalLootModifierSerializer.class, MantleLoot::registerGlobalLootModifiers);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, LecternBookItem::interactWithBlock);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        OffhandCooldownTracker.register(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MantleNetwork.registerPackets();
        MantleCommand.init();
        OffhandCooldownTracker.init();
        TagPreference.init();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        RegistryAdapter adapter = new RegistryAdapter(event.getRegistry());
        adapter.register(new ShapedFallbackRecipe.Serializer(), "crafting_shaped_fallback");
        adapter.register(new ShapedRetexturedRecipe.Serializer(), "crafting_shaped_retextured");
        CraftingHelper.register((IConditionSerializer)TagEmptyCondition.SERIALIZER);
        CraftingHelper.register((ResourceLocation)FluidContainerIngredient.ID, (IIngredientSerializer)FluidContainerIngredient.SERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidContainerTransfer.ID, EmptyFluidContainerTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidContainerTransfer.ID, FillFluidContainerTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(EmptyFluidWithNBTTransfer.ID, EmptyFluidWithNBTTransfer.DESERIALIZER);
        FluidContainerTransferManager.TRANSFER_LOADERS.registerDeserializer(FillFluidWithNBTTransfer.ID, FillFluidWithNBTTransfer.DESERIALIZER);
        BlockPredicate.LOADER.register(Mantle.getResource("and"), BlockPredicate.AND);
        BlockPredicate.LOADER.register(Mantle.getResource("or"), BlockPredicate.OR);
        BlockPredicate.LOADER.register(Mantle.getResource("inverted"), BlockPredicate.INVERTED);
        BlockPredicate.LOADER.register(Mantle.getResource("requires_tool"), BlockPredicate.REQUIRES_TOOL.getLoader());
        BlockPredicate.LOADER.register(Mantle.getResource("set"), SetBlockPredicate.LOADER);
        BlockPredicate.LOADER.register(Mantle.getResource("tag"), TagBlockPredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("and"), LivingEntityPredicate.AND);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("or"), LivingEntityPredicate.OR);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("inverted"), LivingEntityPredicate.INVERTED);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("any"), LivingEntityPredicate.ANY.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("fire_immune"), LivingEntityPredicate.FIRE_IMMUNE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("water_sensitive"), LivingEntityPredicate.WATER_SENSITIVE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("on_fire"), LivingEntityPredicate.ON_FIRE.getLoader());
        LivingEntityPredicate.LOADER.register(Mantle.getResource("tag"), TagEntityPredicate.LOADER);
        LivingEntityPredicate.LOADER.register(Mantle.getResource("mob_type"), MobTypePredicate.LOADER);
        MobTypePredicate.MOB_TYPES.register(new ResourceLocation("undefined"), MobType.f_21640_);
        MobTypePredicate.MOB_TYPES.register(new ResourceLocation("undead"), MobType.f_21641_);
        MobTypePredicate.MOB_TYPES.register(new ResourceLocation("arthropod"), MobType.f_21642_);
        MobTypePredicate.MOB_TYPES.register(new ResourceLocation("illager"), MobType.f_21643_);
        MobTypePredicate.MOB_TYPES.register(new ResourceLocation("water"), MobType.f_21644_);
    }

    private void registerBlockEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        BlockEntityTypeRegistryAdapter adapter = new BlockEntityTypeRegistryAdapter((IForgeRegistry<BlockEntityType<?>>)event.getRegistry());
        adapter.register(MantleSignBlockEntity::new, "sign", MantleSignBlockEntity::buildSignBlocks);
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new MantleFluidTagProvider(generator, event.getExistingFileHelper()));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new MantleFluidTooltipProvider(generator));
        }
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modId, name);
    }

    public static String makeDescriptionId(String base, String name) {
        return Util.m_137492_((String)base, (ResourceLocation)Mantle.getResource(name));
    }

    public static MutableComponent makeComponent(String base, String name) {
        return new TranslatableComponent(Mantle.makeDescriptionId(base, name));
    }
}

