/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.GuiLib;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractButtonNode
extends AbstractGuiNode {
    public static final int BUTTON_STATE_DISABLED = 0;
    public static final int BUTTON_STATE_IDLE = 1;
    public static final int BUTTON_STATE_HIGHLIGHT = 2;

    protected abstract void onButtonClicked();

    protected boolean isButtonDisabled() {
        return false;
    }

    protected void buildTooltip(List<Component> tooltip) {
    }

    protected int getButtonState(boolean mouseover) {
        return this.isButtonDisabled() ? 0 : (mouseover ? 2 : 1);
    }

    @Override
    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        boolean mouseover = this.getFrame().contains(mouse) && this.isFirstHit(mouse);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiLib.WIDGETS_TEXTURE);
        int state = this.getButtonState(mouseover);
        this.drawMCButton(stack, state);
        this.drawButtonBody(stack, mouseover);
    }

    @Override
    public void drawFront(PoseStack stack, Point mouse, float partialFrame) {
        if (!this.isFirstHit(mouse)) {
            return;
        }
        LinkedList<Component> tooltip = new LinkedList<Component>();
        this.buildTooltip(tooltip);
        if (!tooltip.isEmpty()) {
            this.renderTooltip(stack, mouse, tooltip);
        }
    }

    @Override
    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (!consumed && !this.isButtonDisabled() && this.isFirstHit(p)) {
            this.getRoot().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.onButtonClicked();
            return true;
        }
        return false;
    }

    protected void drawMCButton(PoseStack stack, int state) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiLib.WIDGETS_TEXTURE);
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getFrame().width();
        int height = this.getFrame().height();
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)(46 + state * 20), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)stack, (int)(x + width / 2), (int)y, (float)(200.0f - (float)width / 2.0f), (float)(46 + state * 20), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)(y + height / 2), (float)0.0f, (float)((float)(46 + state * 20 + 20) - (float)height / 2.0f), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
        GuiComponent.m_93133_((PoseStack)stack, (int)(x + width / 2), (int)(y + height / 2), (float)(200.0f - (float)width / 2.0f), (float)((float)(46 + state * 20 + 20) - (float)height / 2.0f), (int)(width / 2), (int)(height / 2), (int)256, (int)256);
    }

    protected abstract void drawButtonBody(PoseStack var1, boolean var2);
}

