/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class VecLib {
    public static Cuboid6[] buildCubeArray(int xSize, int zSize, Cuboid6 box, Vector3 expand) {
        box.min.multiply(0.0625);
        box.max.multiply(0.0625);
        expand.multiply(0.0625);
        Cuboid6[] cuboids = new Cuboid6[xSize * zSize];
        for (int i = 0; i < cuboids.length; ++i) {
            int x = i % xSize;
            int z = i / zSize;
            double dx = (box.max.x - box.min.x) / (double)xSize;
            double dz = (box.max.z - box.min.z) / (double)zSize;
            Vector3 min1 = new Vector3(box.min.x + dx * (double)x, box.min.y, box.min.z + dz * (double)z);
            Vector3 max1 = new Vector3(min1.x + dx, box.max.y, min1.z + dz);
            cuboids[i] = new Cuboid6(min1, max1).expand(expand);
        }
        return cuboids;
    }

    public static Transformation orientT(int orient) {
        Transformation t = Rotation.sideOrientation((int)(orient % 24 >> 2), (int)(orient & 3));
        if (orient >= 24) {
            t = new Scale(-1.0, 1.0, 1.0).with(t);
        }
        return t.at(Vector3.CENTER);
    }

    public static int rejectComponent(BlockPos pos, int dir) {
        return VecLib.rejectComponent(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dir);
    }

    public static int rejectComponent(int x, int y, int z, int dir) {
        return switch (dir) {
            case 0, 1 -> y;
            case 2, 3 -> z;
            case 4, 5 -> x;
            default -> throw new IllegalArgumentException("Unexpected value: " + dir);
        };
    }

    public static int sign(int dir) {
        return (dir & 1) == 0 ? -1 : 1;
    }

    public static BlockPos projectDir(BlockPos pos, int dir) {
        return switch (dir) {
            case 0, 1 -> new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
            case 2, 3 -> new BlockPos(pos.m_123341_(), pos.m_123342_(), 0);
            case 4, 5 -> new BlockPos(0, pos.m_123342_(), pos.m_123343_());
            default -> throw new IllegalArgumentException("Unexpected value: " + dir);
        };
    }

    public static BlockPos rejectDir(BlockPos pos, int dir) {
        return switch (dir) {
            case 0, 1 -> new BlockPos(0, pos.m_123342_(), 0);
            case 2, 3 -> new BlockPos(0, 0, pos.m_123343_());
            case 4, 5 -> new BlockPos(pos.m_123341_(), 0, 0);
            default -> throw new IllegalArgumentException("Unexpected value: " + dir);
        };
    }

    public static List<BlockPos> sortTowardsDir(Set<BlockPos> posSet, int dir) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(posSet);
        posList.sort((a, b) -> {
            int ba = VecLib.rejectComponent(a, dir);
            int bb = VecLib.rejectComponent(b, dir);
            return VecLib.sign(dir) * Integer.compare(ba, bb);
        });
        return posList;
    }

    public static List<List<BlockPos>> splitContinuousRows(List<BlockPos> rowList, int dir) {
        LinkedList<List<BlockPos>> rows = new LinkedList<List<BlockPos>>();
        LinkedList<BlockPos> row = new LinkedList<BlockPos>();
        for (BlockPos next : rowList) {
            if (row.isEmpty()) {
                row.addLast(next);
                continue;
            }
            if (((BlockPos)row.getLast()).m_142300_(Direction.values()[dir]).equals((Object)next)) {
                row.addLast(next);
                continue;
            }
            rows.add(row);
            row = new LinkedList();
            row.addLast(next);
        }
        if (!row.isEmpty()) {
            rows.add(row);
        }
        return rows;
    }

    public static Set<List<BlockPos>> resolveRows(Set<BlockPos> posSet, int dir) {
        HashMap<BlockPos, HashSet> projected = new HashMap<BlockPos, HashSet>();
        for (BlockPos blockPos : posSet) {
            BlockPos proj = VecLib.projectDir(blockPos, dir);
            projected.computeIfAbsent(proj, k -> new HashSet()).add(blockPos);
        }
        HashSet<List> rows = new HashSet<List>();
        for (HashSet rowSet : projected.values()) {
            List row = VecLib.sortTowardsDir(rowSet, dir);
            rows.add(row);
        }
        HashSet<List<BlockPos>> hashSet = new HashSet<List<BlockPos>>();
        for (List row : rows) {
            hashSet.addAll(VecLib.splitContinuousRows(row, dir));
        }
        return hashSet;
    }
}

