/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.init.CoreReferences;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.core.inventory.container.ElectrotineGeneratorContainer;
import mrtjp.projectred.core.power.ILowLoadMachine;
import mrtjp.projectred.core.power.ILowLoadPowerLine;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BasePoweredTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ElectrotineGeneratorTile
extends BasePoweredTile
implements ILowLoadMachine {
    protected final PowerConductor conductor = new PowerConductor(this, 0.01, 160.0);
    private int chargeFlow = 0;
    private final ElectrotineGeneratorInventory inventory = new ElectrotineGeneratorInventory();
    private final LazyOptional<? extends IItemHandler> handler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorTile(BlockPos pos, BlockState state) {
        super(CoreReferences.ELECTROTINE_GENERATOR_TILE, pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        this.conductor.save(tag);
        this.inventory.saveTo(tag, "inventory");
        tag.m_128405_("burnTime", this.burnTimeRemaining);
        tag.m_128405_("stored", this.powerStored);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.conductor.load(tag);
        this.inventory.loadFrom(tag, "inventory");
        this.burnTimeRemaining = tag.m_128451_("burnTime");
        this.powerStored = tag.m_128451_("stored");
    }

    @Override
    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).m_61124_((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.canConductorWork()))).m_61124_((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.burnTimeRemaining > 0));
    }

    @Override
    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ElectrotineGeneratorContainer(inv, this, id), (Component)new TranslatableComponent(this.m_58900_().m_60734_().m_7705_())), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        ElectrotineGeneratorTile.dropInventory((Container)this.inventory, this.m_58904_(), Vector3.fromBlockPos((BlockPos)this.m_58899_()));
    }

    @Override
    public void tick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        this.conductor.tick();
        this.chargeFlow <<= 1;
        if (this.canConductorWork()) {
            this.chargeFlow |= 1;
        }
        this.tryBurnDust();
        this.tryChargeStorage();
        this.tryChargeConductor();
        if (this.f_58857_.m_46467_() % 10L == 0L) {
            this.updateRendersIfNeeded();
        }
    }

    @Override
    public PowerConductor getConductor(int dir) {
        return this.conductor;
    }

    @Override
    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (part instanceof ILowLoadPowerLine) {
            return true;
        }
        return part instanceof ILowLoadMachine;
    }

    private void tryBurnDust() {
        ItemStack removedDust;
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining < this.getBurnUseOnCharge() && !(removedDust = this.inventory.m_7407_(0, 1)).m_41619_()) {
            int addedBurnTime = this.getBurnTimeForDust(removedDust);
            this.burnTimeRemaining = Math.min(this.getMaxBurnTime(), this.burnTimeRemaining + addedBurnTime);
        }
    }

    private void tryChargeStorage() {
        if (this.burnTimeRemaining == 0) {
            return;
        }
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining >= this.getBurnUseOnCharge()) {
            ++this.powerStored;
            this.burnTimeRemaining -= this.getBurnUseOnCharge();
        } else {
            this.burnTimeRemaining -= Math.min(this.burnTimeRemaining, this.getBurnUseOnIdle());
        }
    }

    private void tryChargeConductor() {
        if (this.getConductorCharge() < this.getDrawFloor() && this.powerStored > 0) {
            int n = Math.min(this.getDrawFloor() - this.getConductorCharge(), this.getDrawSpeed()) / 10;
            n = Math.min(n, this.powerStored);
            this.conductor.applyPower(n * 1000);
            this.powerStored -= n;
        }
    }

    private void updateRendersIfNeeded() {
        boolean lastWorking = (Boolean)this.m_58900_().m_61143_((Property)ProjectRedBlock.WORKING);
        boolean lastCharged = (Boolean)this.m_58900_().m_61143_((Property)ProjectRedBlock.CHARGED);
        boolean isWorking = this.burnTimeRemaining > 0;
        boolean isCharged = this.canConductorWork();
        if (lastWorking != isWorking || lastCharged != isCharged) {
            this.pushBlockState();
        }
    }

    protected int getBurnTimeForDust(ItemStack dust) {
        return 2750;
    }

    public int getBurnUseOnCharge() {
        return 10;
    }

    public int getBurnUseOnIdle() {
        return 1;
    }

    public int getDrawSpeed() {
        return 100;
    }

    public int getDrawFloor() {
        return 1200;
    }

    public int getMaxStorage() {
        return 800;
    }

    public int getMaxBurnTime() {
        return 2750;
    }

    @Override
    public int getConductorCharge() {
        return (int)(this.conductor.getVoltage() * 10.0);
    }

    @Override
    public int getConductorFlow() {
        return this.chargeFlow;
    }

    @Override
    public boolean canConductorWork() {
        return this.getConductorCharge() > 600;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class ElectrotineGeneratorInventory
    extends BaseInventory {
        public ElectrotineGeneratorInventory() {
            super(1);
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_41720_() == CoreReferences.ELECTROTINE_DUST_ITEM;
        }
    }
}

