/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.init.CoreReferences;
import mrtjp.projectred.core.inventory.container.BasePoweredTileContainer;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.ElectrotineGeneratorTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ElectrotineGeneratorContainer
extends BasePoweredTileContainer {
    public static final ICCLContainerFactory<ElectrotineGeneratorContainer> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof ElectrotineGeneratorTile)) {
            return null;
        }
        return new ElectrotineGeneratorContainer(inventory, (ElectrotineGeneratorTile)tile, windowId);
    };
    private final Inventory playerInventory;
    private final ElectrotineGeneratorTile tile;
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorContainer(Inventory playerInventory, ElectrotineGeneratorTile tile, int windowId) {
        super(CoreReferences.ELECTROTINE_GENERATOR_CONTAINER, windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory(playerInventory, 8, 89, x$0 -> this.m_38897_((Slot)x$0));
        this.addElectrotineGeneratorInventory();
        this.m_38895_(new SimpleDataSlot(tile::getBurnTimeRemaining, value -> {
            this.burnTimeRemaining = value;
        }));
        this.m_38895_(new SimpleDataSlot(tile::getPowerStored, value -> {
            this.powerStored = value;
        }));
    }

    private void addElectrotineGeneratorInventory() {
        this.m_38897_(new Slot((Container)this.tile.getInventory(), 0, 134, 42){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == CoreReferences.ELECTROTINE_DUST_ITEM;
            }
        });
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isFuel(slotIndex) ? !this.moveToEntireInventory(stack, false) : (stack.m_41720_() == CoreReferences.ELECTROTINE_DUST_ITEM ? !this.moveToFuel(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public int getBurnTimeScaled(int scale) {
        return this.burnTimeRemaining == 0 ? 0 : scale * this.burnTimeRemaining / this.tile.getMaxBurnTime();
    }

    public int getPowerStoredScaled(int scale) {
        return this.powerStored == 0 ? 0 : scale * this.powerStored / this.tile.getMaxStorage();
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public boolean isChargingStorage() {
        return this.burnTimeRemaining > this.tile.getBurnUseOnCharge() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean isChargingConductor() {
        return this.condCharge < this.tile.getDrawFloor() && (this.powerStored > 0 || this.burnTimeRemaining > this.tile.getBurnUseOnCharge());
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isFuel(int slotIndex) {
        return slotIndex == 36;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToFuel(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 37, reverse);
    }
}

