/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory.container;

import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.BasePoweredTile;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class BasePoweredTileContainer
extends AbstractContainerMenu {
    private final BasePoweredTile tile;
    protected int condCharge;
    protected int condFlow;

    public BasePoweredTileContainer(@Nullable MenuType<?> containerType, int windowId, BasePoweredTile tile) {
        super(containerType, windowId);
        this.tile = tile;
        this.m_38895_(new SimpleDataSlot(tile::getConductorCharge, value -> {
            this.condCharge = value;
        }));
        this.m_38895_(new SimpleDataSlot(() -> tile.getConductorFlow() & 0xFFFF, value -> {
            this.condFlow = this.condFlow & 0xFFFF0000 | value & 0xFFFF;
        }));
        this.m_38895_(new SimpleDataSlot(() -> tile.getConductorFlow() >> 16 & 0xFFFF, value -> {
            this.condFlow = this.condFlow & 0xFFFF | value << 16;
        }));
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    public int getChargeScaled(int scale) {
        return Math.min(scale, scale * this.condCharge / 1000);
    }

    public int getFlowScaled(int scale) {
        return scale * Integer.bitCount(this.condFlow) / 32;
    }

    public boolean canConductorWork() {
        return this.condCharge > 600;
    }

    public boolean isFlowFull() {
        return this.condFlow == -1;
    }
}

