/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import mrtjp.projectred.api.MovingBlockEntityRenderCallback;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.client.HaloBloomPostChain;
import mrtjp.projectred.core.init.CoreClientInit;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;

public class HaloRenderer {
    @Nullable
    private static HaloBloomPostChain HALO_POST_CHAIN;
    private static final RenderType HALO_GLOW_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_DEPTH_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_BLOOM_RENDER_TYPE;
    private static final RenderType HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE;
    private static boolean postChainFlushPending;
    private static final LinkedList<LevelLight> levelLights;
    private static final Vector3 offset;

    public static void init() {
        if (ProjectRedAPI.expansionAPI != null) {
            ProjectRedAPI.expansionAPI.registerBlockEntityRenderCallback(new MovingBlockEntityRenderCallback(){

                @Override
                public void onMovingPreRender(double offsetX, double offsetY, double offsetZ) {
                    offset.set(offsetX, offsetY, offsetZ);
                }

                @Override
                public void onMovingPostRender() {
                    offset.set(0.0, 0.0, 0.0);
                }
            });
        }
    }

    public static void addLight(BlockPos pos, int colour, Cuboid6 box) {
        HaloRenderer.addLight((Transformation)new Translation((Vec3i)pos), colour, box);
    }

    public static void addLight(Transformation t, int colour, Cuboid6 box) {
        TransformationList t2 = new TransformationList(new Transformation[]{t, new Translation(offset)});
        levelLights.add(new LevelLight((Transformation)t2, colour, box));
        if (Configurator.lightHaloMax > -1 && levelLights.size() > Configurator.lightHaloMax) {
            levelLights.poll();
        }
    }

    public static void onRenderWorldStageEvent(RenderLevelStageEvent event) {
        LevelLight l;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (levelLights.isEmpty()) {
            return;
        }
        if (!HaloRenderer.isFabulous()) {
            return;
        }
        LinkedList<LevelLight> lightList = new LinkedList<LevelLight>();
        while ((l = levelLights.poll()) != null) {
            lightList.add(l);
        }
        HaloRenderer.preparePostChain();
        assert (HALO_POST_CHAIN != null);
        HALO_POST_CHAIN.getInputTarget().m_83954_(Minecraft.f_91002_);
        HALO_POST_CHAIN.getInputTarget().m_83945_(Minecraft.m_91087_().m_91385_());
        Vec3 cam = event.getCamera().m_90583_();
        PoseStack stack = event.getPoseStack();
        stack.m_85836_();
        stack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        ccrs.bind(HALO_GLOW_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (LevelLight light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.colour, light.t, HaloContext.LEVEL_RENDERER);
        }
        ccrs.bind(HALO_FABULOUS_DEPTH_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (LevelLight light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.colour, light.t, HaloContext.LEVEL_RENDERER);
        }
        ccrs.bind(HALO_FABULOUS_BLOOM_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        for (LevelLight light : lightList) {
            HaloRenderer.renderToCCRS(ccrs, light.box, light.colour, light.t, HaloContext.BLOOM_RENDERER);
        }
        postChainFlushPending = true;
        buffers.m_109911_();
        stack.m_85849_();
    }

    public static void onRenderWorldLastEvent(RenderLevelLastEvent event) {
        if (!HaloRenderer.isFabulous()) {
            LevelLight l;
            if (levelLights.isEmpty()) {
                return;
            }
            LinkedList<LevelLight> lightList = new LinkedList<LevelLight>();
            while ((l = levelLights.poll()) != null) {
                lightList.add(l);
            }
            Vec3 cam = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            stack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            ccrs.bind(HALO_GLOW_RENDER_TYPE, (MultiBufferSource)buffers, stack);
            for (LevelLight light : lightList) {
                HaloRenderer.renderToCCRS(ccrs, light.box, light.colour, light.t, HaloContext.LEVEL_RENDERER);
            }
            buffers.m_109911_();
            stack.m_85849_();
        }
        if (HaloRenderer.isFabulous() && postChainFlushPending) {
            postChainFlushPending = false;
            assert (HALO_POST_CHAIN != null);
            HALO_POST_CHAIN.m_110023_(event.getPartialTick());
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    }

    public static void onResourceManagerReload(ResourceManager manager) {
        HaloRenderer.loadPostChain();
    }

    private static void preparePostChain() {
        if (HALO_POST_CHAIN == null) {
            HaloRenderer.loadPostChain();
        }
        HALO_POST_CHAIN.resizeIfNeeded();
    }

    private static void loadPostChain() {
        HaloRenderer.unloadPostChain();
        try {
            HALO_POST_CHAIN = new HaloBloomPostChain();
            HALO_POST_CHAIN.m_110025_(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load halo post chain", e);
        }
    }

    private static void unloadPostChain() {
        if (HALO_POST_CHAIN != null) {
            HALO_POST_CHAIN.close();
            HALO_POST_CHAIN = null;
        }
    }

    private static boolean isFabulous() {
        return Configurator.fabulousLights && Minecraft.m_91087_().f_91066_.f_92115_.m_90773_() >= GraphicsStatus.FABULOUS.m_90773_();
    }

    private static void renderToCCRS(CCRenderState ccrs, Cuboid6 cuboid, int colour, Transformation t, HaloContext context) {
        ccrs.setPipeline(new IVertexOperation[]{t});
        ccrs.baseColour = HaloRenderer.getBaseColour(colour, context);
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)cuboid, (int)0);
    }

    public static void renderInventoryHalo(CCRenderState ccrs, PoseStack mStack, MultiBufferSource buffers, Cuboid6 cuboid, int colour, Vector3 pos) {
        RenderType type = HaloRenderer.isFabulous() ? HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE : HALO_GLOW_RENDER_TYPE;
        ccrs.reset();
        ccrs.bind(type, buffers, mStack);
        HaloRenderer.renderToCCRS(ccrs, cuboid, colour, (Transformation)pos.translation(), HaloContext.ITEM_RENDERER);
    }

    private static int getBaseColour(int colorIndex, HaloContext context) {
        return LightColours.byIndex(colorIndex).rgbaByContext(context);
    }

    static {
        HALO_GLOW_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110136_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110126_).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        HALO_FABULOUS_DEPTH_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_depth", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110134_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110126_).m_110687_(RenderStateShard.f_110116_).m_110691_(false));
        HALO_FABULOUS_BLOOM_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_bloom", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)2048, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110134_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(new RenderStateShard.OutputStateShard("halo_post", () -> HALO_POST_CHAIN.getInputTarget().m_83947_(false), () -> Minecraft.m_91087_().m_91385_().m_83947_(false))).m_110687_(RenderStateShard.f_110115_).m_110691_(false));
        HALO_FABULOUS_ITEM_ENTITY_RENDER_TYPE = RenderType.m_173215_((String)"projectred_core:halo_item_entity", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110136_).m_173292_(new RenderStateShard.ShaderStateShard(() -> CoreClientInit.HALO_SHADER)).m_110661_(RenderStateShard.f_110158_).m_110675_(RenderStateShard.f_110123_).m_110687_(RenderStateShard.f_110114_).m_110691_(false));
        postChainFlushPending = false;
        levelLights = new LinkedList();
        offset = Vector3.ZERO.copy();
    }

    private record LevelLight(Transformation t, int colour, Cuboid6 box) {
    }

    private static enum HaloContext {
        ITEM_RENDERER,
        LEVEL_RENDERER,
        BLOOM_RENDERER;

    }

    private static enum LightColours {
        WHITE(-96, 0.9f, 0.8f, 0.8f),
        ORANGE(-1067253600, 0.8f, 0.8f, 0.8f),
        MAGENTA(-1256540768, 0.8f, 0.8f, 0.8f),
        LIGHT_BLUE(1870983584, 0.9f, 0.9f, 0.9f),
        YELLOW(-1078001504, 0.8f, 0.8f, 0.8f),
        LIME(1810956448, 0.9f, 0.9f, 0.9f),
        PINK(-247040608, 0.9f, 0.9f, 0.9f),
        GRAY(1397969824, 0.5f, 0.5f, 0.5f),
        LIGHT_GRAY(-1819044960, 0.6f, 0.6f, 0.6f),
        CYAN(8882080, 0.8f, 0.8f, 0.8f),
        PURPLE(1577107616, 0.8f, 0.8f, 0.8f),
        BLUE(320061600, 0.8f, 0.8f, 0.8f),
        BROWN(1327956128, 0.5f, 0.5f, 0.5f),
        GREEN(143065248, 0.7f, 0.7f, 0.7f),
        RED(-1576073568, 0.8f, 0.8f, 0.8f),
        BLACK(522133408, 0.4f, 0.4f, 0.4f);

        private final int rgba;
        private final float glowBrightness;
        private final float itemGlowBrightness;
        private final float bloomBrightness;
        public final int blockGlowRgba;
        public final int itemGlowRgba;
        public final int bloomRgba;

        private LightColours(int rgba, float glowBrightness, float itemGlowBrightness, float bloomBrightness) {
            this.rgba = rgba;
            this.glowBrightness = glowBrightness;
            this.itemGlowBrightness = itemGlowBrightness;
            this.bloomBrightness = bloomBrightness;
            this.blockGlowRgba = LightColours.scaleBrightness(rgba, glowBrightness);
            this.itemGlowRgba = LightColours.scaleBrightness(rgba, itemGlowBrightness);
            this.bloomRgba = LightColours.scaleBrightness(rgba, bloomBrightness);
        }

        public int rgbaByContext(HaloContext context) {
            return switch (context) {
                default -> throw new IncompatibleClassChangeError();
                case HaloContext.ITEM_RENDERER -> this.itemGlowRgba;
                case HaloContext.LEVEL_RENDERER -> this.blockGlowRgba;
                case HaloContext.BLOOM_RENDERER -> this.bloomRgba;
            };
        }

        private static int scaleBrightness(int baseRgba, float brightness) {
            int r = baseRgba >> 24 & 0xFF;
            int g = baseRgba >> 16 & 0xFF;
            int b = baseRgba >> 8 & 0xFF;
            int a = baseRgba & 0xFF;
            float[] hsb = new float[3];
            Color.RGBtoHSB(r, g, b, hsb);
            return Color.HSBtoRGB(hsb[0], hsb[1], brightness) << 8 | a;
        }

        public static LightColours byIndex(int index) {
            return LightColours.values()[index];
        }
    }
}

