/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.MultiIconTransformation;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public abstract class FullyOrientableBlockRenderer
implements ICCBlockRenderer,
IItemRenderer {
    private static final CCModel[] models = new CCModel[24];

    private static int modelKey(int side, int rot) {
        return side << 2 | rot & 3;
    }

    protected abstract RenderType getBlockRenderLayer(BlockState var1, BlockPos var2, BlockAndTintGetter var3);

    protected abstract RenderData getBlockRenderData(BlockState var1, BlockPos var2, BlockAndTintGetter var3);

    protected abstract RenderData getItemRenderData(ItemStack var1);

    public boolean renderBlock(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, Random random, IModelData data) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((VertexConsumer)new TransformingVertexConsumer(builder, mStack), DefaultVertexFormat.f_85811_);
        ccrs.lightMatrix.locate(world, pos);
        this.render(ccrs, MinecraftForgeClient.getRenderType(), this.getBlockRenderData(state, pos, world));
        return true;
    }

    public void renderItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack mStack, MultiBufferSource source, int packedLight, int packedOverlay) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true), source, mStack);
        this.render(ccrs, null, this.getItemRenderData(stack));
    }

    private void render(CCRenderState ccrs, @Nullable RenderType layer, RenderData data) {
        CCModel model = models[FullyOrientableBlockRenderer.modelKey(data.side, data.rotation)];
        MultiIconTransformation iconT = data.iconT;
        if (layer != null) {
            model.render(ccrs, new IVertexOperation[]{iconT, ccrs.lightMatrix});
        } else {
            model.render(ccrs, new IVertexOperation[]{iconT});
        }
    }

    static {
        CCModel baseModel = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full);
        for (int s = 0; s < 6; ++s) {
            for (int r = 0; r < 4; ++r) {
                CCModel m = baseModel.copy().apply(Rotation.sideOrientation((int)s, (int)r).at(Vector3.CENTER));
                m.computeNormals();
                m.shrinkUVs(5.0E-4);
                m.computeLightCoords();
                FullyOrientableBlockRenderer.models[FullyOrientableBlockRenderer.modelKey((int)s, (int)r)] = m;
            }
        }
    }

    public record RenderData(int side, int rotation, MultiIconTransformation iconT) {
    }
}

