/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.compatibility.ComputerCraftCompatibility;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.data.CoreBlockStateModelProvider;
import mrtjp.projectred.core.data.CoreBlockTagsProvider;
import mrtjp.projectred.core.data.CoreItemModelProvider;
import mrtjp.projectred.core.data.CoreItemTagsProvider;
import mrtjp.projectred.core.data.CoreLanguageProvider;
import mrtjp.projectred.core.data.CoreLootTableProvider;
import mrtjp.projectred.core.data.CoreRecipeProvider;
import mrtjp.projectred.core.init.CoreBlocks;
import mrtjp.projectred.core.init.CoreClientInit;
import mrtjp.projectred.core.init.CoreContainers;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreParts;
import mrtjp.projectred.core.init.CoreReferences;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.OptionalMod;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectred_core")
public class ProjectRedCore {
    public static final String MOD_ID = "projectred_core";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_core");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred_core");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"projectred_core");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"projectred_core");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_core");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"projectred_core");
    public static final DeferredRegister<MultipartType<?>> PARTS = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_core");
    public static final SimpleCreativeTab CORE_CREATIVE_TAB = new SimpleCreativeTab("projectred_core", () -> new ItemStack((ItemLike)CoreReferences.RED_ALLOY_INGOT_ITEM));

    public ProjectRedCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CoreClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        PARTS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CoreNetwork.init();
        Configurator.load();
        if (Configurator.compat_CCBundledCable) {
            OptionalMod.of((String)"computercraft").ifPresent(mod -> ComputerCraftCompatibility.init(mod));
        }
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new CoreBlockStateModelProvider(generator, fileHelper));
            generator.m_123914_((DataProvider)new CoreItemModelProvider(generator, fileHelper));
            generator.m_123914_((DataProvider)new CoreLanguageProvider(generator));
        }
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new CoreRecipeProvider(generator));
            generator.m_123914_((DataProvider)new CoreLootTableProvider(generator));
            generator.m_123914_((DataProvider)new CoreItemTagsProvider(generator, fileHelper));
            generator.m_123914_((DataProvider)new CoreBlockTagsProvider(generator, fileHelper));
        }
    }

    static {
        CoreBlocks.register();
        CoreItems.register();
        CoreContainers.register();
        CoreParts.register();
    }
}

