/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CenterLookup {
    public final Level world;
    public final BlockPos pos;
    public final int direction;
    public final BlockState state;
    public final Block block;
    @Nullable
    public final BlockEntity tile;
    @Nullable
    public final MultiPart part;
    public final BlockPos otherPos;
    public final int otherDirection;

    public CenterLookup(Level world, BlockPos pos, int direction, BlockState state, @Nullable BlockEntity tile, @Nullable MultiPart part, BlockPos otherPos, int otherDirection) {
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.state = state;
        this.block = state.m_60734_();
        this.tile = tile;
        this.part = part;
        this.otherPos = otherPos;
        this.otherDirection = otherDirection;
    }

    public static CenterLookup lookupInsideFace(Level world, BlockPos pos, int direction) {
        int otherDir = direction ^ 1;
        BlockState state = world.m_8055_(pos);
        BlockEntity tile = world.m_7702_(pos);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(direction);
        }
        return new CenterLookup(world, pos, direction, state, tile, part, pos, otherDir);
    }

    public static CenterLookup lookupStraightCenter(Level world, BlockPos pos, int direction) {
        BlockPos otherPos = pos.m_142300_(Direction.values()[direction]);
        int otherDir = direction ^ 1;
        BlockState state = world.m_8055_(otherPos);
        BlockEntity tile = world.m_7702_(otherPos);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(6);
        }
        return new CenterLookup(world, pos, direction, state, tile, part, otherPos, otherDir);
    }
}

