/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.enchdesc.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.darkhax.enchdesc.Constants;
import net.darkhax.enchdesc.DescriptionManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentInfoEntry
implements IRecipeCategoryExtension {
    private final Enchantment enchantment;
    private final Component name;
    private final Component description;
    private final int maxLevel;
    private final List<Enchantment> incompatibleEnchantments;
    private final List<ItemStack> books;
    private final List<ItemStack> compatibleItems;
    private static Map<Enchantment, NonNullList<ItemStack>> compatibleItemsCache;

    public EnchantmentInfoEntry(Enchantment enchantment) {
        this.enchantment = enchantment;
        this.name = new TranslatableComponent(enchantment.m_44704_()).m_130940_(ChatFormatting.BLACK);
        this.description = DescriptionManager.getDescription(enchantment).m_6881_().m_130940_(ChatFormatting.BLACK);
        this.maxLevel = enchantment.m_6586_();
        this.incompatibleEnchantments = EnchantmentInfoEntry.getIncompatibleEnchantments(enchantment);
        this.books = EnchantmentInfoEntry.getEnchantedBooks(enchantment);
        this.compatibleItems = EnchantmentInfoEntry.getCompatibleItems(enchantment);
    }

    public void setIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.compatibleItems);
        ingredients.setOutputs(VanillaTypes.ITEM, this.books);
    }

    public Component getName() {
        return this.name;
    }

    public Component getDescription() {
        return this.description;
    }

    public String getDescriptionKey() {
        return this.enchantment.m_44704_() + ".desc";
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public List<Enchantment> getIncompatibleEnchantments() {
        return this.incompatibleEnchantments;
    }

    public List<ItemStack> getBooks() {
        return this.books;
    }

    public List<ItemStack> getCompatibleItems() {
        return this.compatibleItems;
    }

    public void getTooltip(int slotIndex, boolean input, ItemStack stack, List<Component> tooltip) {
        if (this.enchantment.canApplyAtEnchantingTable(stack) && !this.enchantment.m_6591_()) {
            tooltip.add((Component)Blocks.f_50201_.m_49954_().m_130940_(ChatFormatting.GREEN));
        }
        if (this.enchantment.m_6081_(stack)) {
            tooltip.add((Component)Blocks.f_50322_.m_49954_().m_130940_(ChatFormatting.GREEN));
        }
    }

    private static NonNullList<ItemStack> getCompatibleItems(Enchantment enchantment) {
        if (compatibleItemsCache == null) {
            EnchantmentInfoEntry.buildCompatibilityCache();
        }
        return compatibleItemsCache.getOrDefault(enchantment, (NonNullList<ItemStack>)NonNullList.m_122779_());
    }

    private static void buildCompatibilityCache() {
        compatibleItemsCache = new HashMap<Enchantment, NonNullList<ItemStack>>();
        for (Item item : ForgeRegistries.ITEMS) {
            try {
                ItemStack stack = new ItemStack((ItemLike)item);
                if (!stack.m_41792_()) continue;
                for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                    if (!enchantment.m_6081_(stack) && !enchantment.canApplyAtEnchantingTable(stack)) continue;
                    compatibleItemsCache.computeIfAbsent(enchantment, e -> NonNullList.m_122779_()).add((Object)stack);
                }
            }
            catch (Exception e2) {
                Constants.LOG.error("Failed to determine enchantment compatibility for Item \"{}\".", (Object)item.getRegistryName());
                Constants.LOG.catching((Throwable)e2);
            }
        }
    }

    private static List<Enchantment> getIncompatibleEnchantments(Enchantment enchantment) {
        NonNullList incompatible = NonNullList.m_122779_();
        for (Enchantment other : ForgeRegistries.ENCHANTMENTS) {
            if (other == enchantment || enchantment.m_44695_(other)) continue;
            incompatible.add(other);
        }
        return incompatible;
    }

    private static List<ItemStack> getEnchantedBooks(Enchantment enchantment) {
        NonNullList books = NonNullList.m_122779_();
        for (int lvl = enchantment.m_44702_(); lvl <= enchantment.m_6586_(); ++lvl) {
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchantment, lvl));
            books.add(book);
        }
        return books;
    }
}

