/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes.internal;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.internal.BaseMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.IRecipeCatalyst;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class CatalyzedMachineRecipe
extends BaseMachineRecipe {
    protected final int catalystSlot;
    protected boolean catalyzable;

    protected CatalyzedMachineRecipe(int catalystSlot, int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
        super(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.catalystSlot = catalystSlot;
        Iterator iterator = this.outputItemChances.iterator();
        while (iterator.hasNext()) {
            float f = ((Float)iterator.next()).floatValue();
            this.catalyzable |= f >= 0.0f;
        }
    }

    public CatalyzedMachineRecipe(int energy, float experience, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
        this(1, energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
    }

    public abstract IRecipeCatalyst getCatalyst(ItemStack var1);

    @Override
    public List<Float> getOutputItemChances(IMachineInventory inventory) {
        ArrayList<Float> modifiedChances = new ArrayList<Float>(this.outputItemChances);
        if (this.catalyzable && inventory.inputSlots().size() > this.catalystSlot) {
            IRecipeCatalyst catalyst = this.getCatalyst(inventory.inputSlots().get(this.catalystSlot).getItemStack());
            if (catalyst == null) {
                return super.getOutputItemChances(inventory);
            }
            for (int i = 0; i < modifiedChances.size(); ++i) {
                if (modifiedChances.get(i).floatValue() < 0.0f) {
                    modifiedChances.set(i, Float.valueOf(Math.abs(modifiedChances.get(i).floatValue())));
                    continue;
                }
                modifiedChances.set(i, Float.valueOf(Math.max(modifiedChances.get(i).floatValue() * (i == 0 ? catalyst.getPrimaryMod() * inventory.getMachineProperties().getPrimaryMod() : catalyst.getSecondaryMod() * inventory.getMachineProperties().getSecondaryMod()), Math.max(catalyst.getMinOutputChance(), inventory.getMachineProperties().getMinOutputChance()))));
            }
            return modifiedChances;
        }
        return super.getOutputItemChances(inventory);
    }

    @Override
    public List<Integer> getInputItemCounts(IMachineInventory inventory) {
        if (this.inputItems.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.catalyzable && inventory.inputSlots().size() > this.catalystSlot) {
            int[] ret = new int[inventory.inputSlots().size()];
            block0: for (ItemStack input : this.inputItems) {
                for (int j = 0; j < ret.length; ++j) {
                    if (!ItemHelper.itemsEqual((ItemStack)input, (ItemStack)inventory.inputSlots().get(j).getItemStack())) continue;
                    ret[j] = input.m_41613_();
                    continue block0;
                }
            }
            IRecipeCatalyst catalyst = this.getCatalyst(inventory.inputSlots().get(this.catalystSlot).getItemStack());
            if (catalyst != null && MathHelper.RANDOM.nextFloat() < catalyst.getUseChance() * inventory.getMachineProperties().getUseChance()) {
                ret[this.catalystSlot] = 1;
            }
            return IntStream.of(ret).boxed().collect(Collectors.toList());
        }
        return super.getInputItemCounts(inventory);
    }

    @Override
    public int getEnergy(IMachineInventory inventory) {
        if (this.catalyzable && inventory.inputSlots().size() > this.catalystSlot) {
            IRecipeCatalyst catalyst = this.getCatalyst(inventory.inputSlots().get(this.catalystSlot).getItemStack());
            return catalyst == null ? super.getEnergy(inventory) : Math.abs(Math.round(catalyst.getEnergyMod() * (float)super.getEnergy(inventory)));
        }
        return super.getEnergy(inventory);
    }

    @Override
    public float getXp(IMachineInventory inventory) {
        if (this.catalyzable && inventory.inputSlots().size() > this.catalystSlot) {
            IRecipeCatalyst catalyst = this.getCatalyst(inventory.inputSlots().get(this.catalystSlot).getItemStack());
            return catalyst == null ? super.getXp(inventory) : Math.abs(catalyst.getXpMod() * super.getXp(inventory));
        }
        return super.getXp(inventory);
    }
}

