/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.FisherBoost;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FisherBoostSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<FisherBoost> {
    public FisherBoost fromJson(ResourceLocation recipeId, JsonObject json) {
        ResourceLocation lootTable = BuiltInLootTables.f_78723_;
        float outputMod = 1.0f;
        float useChance = 1.0f;
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("loot_table")) {
            String lootTableString = json.get("loot_table").getAsString();
            lootTable = ResourceLocation.m_135820_((String)lootTableString);
        }
        if (json.has("output")) {
            outputMod = json.get("output").getAsFloat();
        } else if (json.has("output_mod")) {
            outputMod = json.get("output_mod").getAsFloat();
        }
        if (json.has("use_chance")) {
            useChance = json.get("use_chance").getAsFloat();
        }
        return new FisherBoost(recipeId, ingredient, lootTable, outputMod, useChance);
    }

    @Nullable
    public FisherBoost fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ResourceLocation lootTable = buffer.m_130281_();
        float outputMod = buffer.readFloat();
        float useChance = buffer.readFloat();
        return new FisherBoost(recipeId, ingredient, lootTable, outputMod, useChance);
    }

    public void toNetwork(FriendlyByteBuf buffer, FisherBoost recipe) {
        recipe.ingredient.m_43923_(buffer);
        buffer.m_130085_(recipe.lootTable);
        buffer.writeFloat(recipe.outputMod);
        buffer.writeFloat(recipe.useChance);
    }
}

