/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.machine;

import cofh.core.init.CoreFluids;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.machine.BottlerRecipe;
import cofh.thermal.core.util.recipes.machine.BottlerRecipeNBT;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BottlerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final BottlerRecipeManager INSTANCE = new BottlerRecipeManager();
    protected static final int DEFAULT_ENERGY = 400;
    protected static boolean defaultBucketRecipes = true;
    protected static boolean defaultPotionRecipes = true;
    protected Map<List<Integer>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 0;
    protected List<BottlerRecipe> convertedRecipes = new ArrayList<BottlerRecipe>();

    public static BottlerRecipeManager instance() {
        return INSTANCE;
    }

    private BottlerRecipeManager() {
        super(400);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (!recipe.getInputItems().isEmpty()) {
            for (ItemStack recipeInput : recipe.getInputItems().get(0).m_43908_()) {
                for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.singletonList(recipeInput), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                }
            }
        } else {
            for (FluidStack fluidInput : recipe.getInputFluids().get(0).getFluids()) {
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), Collections.singletonList(fluidInput), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(BottlerRecipeManager.makeComparable(item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
        this.convertedRecipes.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackHolder> inputSlots, List<? extends IFluidStackHolder> inputTanks) {
        if (inputSlots.isEmpty() && inputTanks.isEmpty() || inputSlots.get(0).isEmpty() && inputTanks.get(0).isEmpty()) {
            return null;
        }
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            ItemStack inputItem = inputSlots.get(0).getItemStack();
            return this.recipeMap.get(Collections.singletonList(BottlerRecipeManager.makeComparable(inputItem).hashCode()));
        }
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            FluidStack inputFluid = inputTanks.get(0).getFluidStack();
            return this.recipeMap.get(Collections.singletonList(FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)));
        }
        ItemStack inputItem = inputSlots.get(0).getItemStack();
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(Arrays.asList(BottlerRecipeManager.makeComparable(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || inputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack inputItem = inputItems.get(0);
        if (inputItem.m_41619_()) {
            return null;
        }
        FluidStack inputFluid = inputFluids.get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        for (ItemStack stack : outputItems) {
            if (!stack.m_41619_()) continue;
            return null;
        }
        this.validItems.add(BottlerRecipeManager.makeComparable(inputItem));
        this.validFluids.add(inputFluid.getFluid());
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(Arrays.asList(BottlerRecipeManager.makeComparable(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)), recipe);
        return recipe;
    }

    protected IMachineRecipe addRecipe(IMachineRecipe recipe) {
        ItemStack inputItem = recipe.getInputItems().get(0);
        if (inputItem.m_41619_()) {
            return null;
        }
        FluidStack inputFluid = recipe.getInputFluids().get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        this.validItems.add(BottlerRecipeManager.makeComparable(inputItem));
        this.validFluids.add(inputFluid.getFluid());
        this.recipeMap.put(Arrays.asList(BottlerRecipeManager.makeComparable(inputItem).hashCode(), FluidHelper.fluidHashcodeNoTag((FluidStack)inputFluid)), recipe);
        return recipe;
    }

    @Override
    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    @Override
    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        int energy = (int)((float)this.getDefaultEnergy() * this.getDefaultScale());
        if (defaultBucketRecipes) {
            ThermalCore.LOG.debug("Adding default Bucket recipes to the Fluid Encapsulator...");
            ObjectOpenHashSet bucketFluids = new ObjectOpenHashSet(32);
            for (Fluid fluid : ForgeRegistries.FLUIDS) {
                if (!(fluid instanceof FlowingFluid)) continue;
                FlowingFluid flowing = (FlowingFluid)fluid;
                Fluid still = null;
                try {
                    still = flowing.m_5613_();
                }
                catch (Exception e) {
                    ThermalCore.LOG.error("Fluid " + fluid.getRegistryName() + " had a critical error when attempting to query its still form!");
                }
                if (still == null) {
                    ThermalCore.LOG.error("Fluid " + fluid.getRegistryName() + " returned a null value for its Still Fluid! This is an error. Report this to the mod author. Probable mod: " + fluid.getRegistryName().m_135827_());
                    continue;
                }
                ItemStack bucket = new ItemStack((ItemLike)still.m_6859_());
                if (bucket.m_41619_() || bucketFluids.contains(still)) continue;
                this.addRecipe(this.convert(energy, 0.0f, new ItemStack((ItemLike)Items.f_42446_), new FluidStack(still, 1000), bucket));
                bucketFluids.add(still);
            }
        }
        if (defaultPotionRecipes) {
            ThermalCore.LOG.debug("Adding default Potion recipes to the Fluid Encapsulator...");
            this.addRecipe(this.convert(energy, 0.0f, new ItemStack((ItemLike)Items.f_42590_), new FluidStack((Fluid)CoreFluids.POTION_FLUID.get(), 250), new ItemStack((ItemLike)Items.f_42589_)));
        }
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.RECIPE_BOTTLER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)((Object)entry.getValue()));
        }
    }

    public List<BottlerRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected BottlerRecipeNBT convert(int energy, float experience, @Nonnull ItemStack inputItem, @Nonnull FluidStack inputFluid, @Nonnull ItemStack outputItem) {
        this.convertedRecipes.add(new BottlerRecipe(new ResourceLocation("thermal", "bottler_" + inputItem.m_41720_().getRegistryName().m_135815_()), energy, experience, Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{inputItem})), Collections.singletonList(FluidIngredient.of((FluidStack[])new FluidStack[]{inputFluid}).setAmount(inputFluid.getAmount())), Collections.singletonList(outputItem), Collections.emptyList(), Collections.emptyList()));
        return new BottlerRecipeNBT(energy, experience, inputItem, inputFluid, outputItem);
    }
}

