/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.patchouli;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CraftingProcessor
implements IComponentProcessor {
    private CraftingRecipe recipe;

    public void setup(IVariableProvider variables) {
        if (!variables.has("recipe")) {
            return;
        }
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        Optional recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(recipeId);
        if (recipe.isPresent() && recipe.get() instanceof CraftingRecipe) {
            this.recipe = (CraftingRecipe)recipe.get();
        } else {
            LogManager.getLogger().warn("Thermalpedia missing the crafting recipe: " + recipeId);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("out")) {
            return IVariable.from((Object)this.recipe.m_8043_());
        }
        if (key.startsWith("in")) {
            int width;
            int index = Integer.parseInt(key.substring(key.length() - 1));
            if (this.recipe instanceof ShapedRecipe && (width = ((ShapedRecipe)this.recipe).getRecipeWidth()) < 3) {
                if (index % 3 >= width) {
                    return null;
                }
                index = index * width / 3 + index % 3;
            }
            if (this.recipe.m_7527_().size() <= index) {
                return null;
            }
            return IVariable.wrapList((Iterable)Arrays.stream(((Ingredient)this.recipe.m_7527_().get(index)).m_43908_()).map(IVariable::from).collect(Collectors.toList()));
        }
        if (key.equals("title")) {
            return IVariable.from((Object)this.recipe.m_8043_().m_41786_());
        }
        if (key.equals("show")) {
            return IVariable.wrap((Boolean)true);
        }
        return null;
    }
}

