/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.model;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.lib.api.ContainerType;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.client.renderer.model.RetexturedBakedQuad;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.client.ThermalTextures;
import cofh.thermal.lib.util.Constants;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class EnergyCellBakedModel
extends BakedModelWrapper<BakedModel>
implements IDynamicBakedModel {
    private static final Map<List<Integer>, BakedQuad> FACE_QUAD_CACHE = new Object2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> SIDE_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Int2ObjectMap<BakedQuad[]> ITEM_QUAD_CACHE = new Int2ObjectOpenHashMap();
    private static final Map<List<Integer>, BakedModel> MODEL_CACHE = new Object2ObjectOpenHashMap();
    private final ItemOverrides overrideList = new ItemOverrides(){

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            CompoundTag tag = stack.m_41737_("BlockEntityTag");
            byte[] sideConfigRaw = EnergyCellBakedModel.this.getSideConfigRaw(tag);
            int itemHash = new ComparableItemStack(stack).hashCode();
            int level = EnergyCellBakedModel.this.getLevel(stack);
            int configHash = Arrays.hashCode(sideConfigRaw);
            BakedModel ret = MODEL_CACHE.get(Arrays.asList(itemHash, level, configHash));
            if (ret == null) {
                ModelUtils.WrappedBakedModelBuilder builder = new ModelUtils.WrappedBakedModelBuilder(model);
                builder.addFaceQuad(Direction.NORTH, (BakedQuad)new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.NORTH).get(0), EnergyCellBakedModel.this.getLevelTexture(level)));
                BakedQuad[] cachedQuads = (BakedQuad[])ITEM_QUAD_CACHE.get(configHash);
                if (cachedQuads == null || cachedQuads.length < 6) {
                    cachedQuads = new BakedQuad[]{new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.DOWN).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[0])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.UP).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[1])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.NORTH).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[2])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.SOUTH).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[3])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.WEST).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[4])), new RetexturedBakedQuad((BakedQuad)builder.getQuads(Direction.EAST).get(0), EnergyCellBakedModel.this.getConfigTexture(sideConfigRaw[5]))};
                    ITEM_QUAD_CACHE.put(configHash, (Object)cachedQuads);
                }
                builder.addFaceQuad(Direction.DOWN, cachedQuads[0]);
                builder.addFaceQuad(Direction.UP, cachedQuads[1]);
                builder.addFaceQuad(Direction.NORTH, cachedQuads[2]);
                builder.addFaceQuad(Direction.SOUTH, cachedQuads[3]);
                builder.addFaceQuad(Direction.WEST, cachedQuads[4]);
                builder.addFaceQuad(Direction.EAST, cachedQuads[5]);
                ret = builder.build();
                MODEL_CACHE.put(Arrays.asList(itemHash, level, configHash), ret);
            }
            return ret;
        }
    };

    public static void clearCache() {
        FACE_QUAD_CACHE.clear();
        SIDE_QUAD_CACHE.clear();
        ITEM_QUAD_CACHE.clear();
        MODEL_CACHE.clear();
    }

    public EnergyCellBakedModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        byte[] sideConfigRaw;
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.originalModel.getQuads(state, side, rand, extraData));
        if (side == null || quads.isEmpty()) {
            return quads;
        }
        BakedQuad baseQuad = quads.get(0);
        int sideIndex = side.m_122411_();
        Direction face = (Direction)extraData.getData(ModelUtils.FACING);
        if (side == face) {
            Integer level = (Integer)extraData.getData(ModelUtils.LEVEL);
            if (level == null) {
                return quads;
            }
            BakedQuad faceQuad = FACE_QUAD_CACHE.get(Arrays.asList(face.m_122411_(), level));
            if (faceQuad == null) {
                faceQuad = new RetexturedBakedQuad(baseQuad, this.getLevelTexture(level));
                FACE_QUAD_CACHE.put(Arrays.asList(face.m_122411_(), level), faceQuad);
            }
            quads.add(faceQuad);
        }
        if ((sideConfigRaw = (byte[])extraData.getData(ModelUtils.SIDES)) == null) {
            return quads;
        }
        int configHash = Arrays.hashCode(sideConfigRaw);
        BakedQuad[] cachedSideQuads = (BakedQuad[])SIDE_QUAD_CACHE.get(configHash);
        if (cachedSideQuads == null || cachedSideQuads.length < 6) {
            cachedSideQuads = new BakedQuad[6];
        }
        if (cachedSideQuads[sideIndex] == null) {
            cachedSideQuads[sideIndex] = new RetexturedBakedQuad(baseQuad, this.getConfigTexture(sideConfigRaw[sideIndex]));
            SIDE_QUAD_CACHE.put(configHash, (Object)cachedSideQuads);
        }
        quads.add(cachedSideQuads[sideIndex]);
        return quads;
    }

    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    private TextureAtlasSprite getConfigTexture(byte side) {
        switch (side) {
            case 1: {
                return ThermalTextures.CELL_CONFIG_INPUT;
            }
            case 2: {
                return ThermalTextures.CELL_CONFIG_OUTPUT;
            }
            case 3: {
                return ThermalTextures.CELL_CONFIG_BOTH;
            }
        }
        return ThermalTextures.CELL_CONFIG_NONE;
    }

    private TextureAtlasSprite getLevelTexture(int level) {
        if (level > 8) {
            return ThermalTextures.ENERGY_CELL_LEVEL_8_C;
        }
        return ThermalTextures.ENERGY_CELL_LEVELS[MathHelper.clamp((int)level, (int)0, (int)8)];
    }

    private byte[] getSideConfigRaw(CompoundTag tag) {
        if (tag == null) {
            return Constants.DEFAULT_CELL_SIDES_RAW;
        }
        byte[] ret = tag.m_128463_("Sides");
        return ret.length == 0 ? Constants.DEFAULT_CELL_SIDES_RAW : ret;
    }

    private int getLevel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)item;
            if (energyContainer.isCreative(stack, ContainerType.ENERGY)) {
                return 9;
            }
            if (energyContainer.getEnergyStored(stack) > 0) {
                return 1 + Math.min(energyContainer.getScaledEnergyStored(stack, 8), 7);
            }
        }
        return 0;
    }
}

