/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.ChargeBenchContainer;
import cofh.thermal.lib.block.entity.AugmentableBlockEntity;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class ChargeBenchBlockEntity
extends AugmentableBlockEntity
implements ITickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "RF", "Filter");
    public static final int BASE_CAPACITY = 500000;
    public static final int BASE_XFER = 4000;
    protected ItemStorageCoFH[] benchSlots = new ItemStorageCoFH[9];
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, ThermalEnergyHelper::hasEnergyHandlerCap);

    public ChargeBenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.CHARGE_BENCH_TILE.get(), pos, state);
        this.energyStorage = new EnergyStorageCoFH(500000, 4000);
        for (int i = 0; i < this.benchSlots.length; ++i) {
            this.benchSlots[i] = new ItemStorageCoFH(1, item -> this.filter.valid(item) && ThermalEnergyHelper.hasEnergyHandlerCap(item));
            this.inventory.addSlot(this.benchSlots[i], StorageGroup.ACCESSIBLE);
        }
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.storageAugments);
        this.initHandlers();
    }

    public void tickServer() {
        boolean curActive = this.isActive;
        this.isActive = false;
        if (this.redstoneControl().getState()) {
            this.chargeItems();
        }
        this.updateActiveState(curActive);
        this.chargeEnergy();
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            int maxTransfer = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace());
            this.chargeSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(maxTransfer, false), false));
        }
    }

    protected void chargeItems() {
        for (ItemStorageCoFH benchSlot : this.benchSlots) {
            LazyOptional lazyOpt = benchSlot.getItemStack().getCapability(ThermalEnergyHelper.getBaseEnergySystem(), null);
            lazyOpt.ifPresent(c -> {
                if (c.getEnergyStored() < c.getMaxEnergyStored()) {
                    this.isActive = true;
                    if (!this.energyStorage.isEmpty()) {
                        int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
                        this.energyStorage.extractEnergy(c.receiveEnergy(maxTransfer, false), false);
                    }
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ChargeBenchContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

